/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.match;

import org.locationtech.jts.algorithm.match.FrechetSimilarityMeasure;
import org.locationtech.jts.geom.Geometry;
import test.jts.GeometryTestCase;

public class FrechetSimilarityMeasureTest
extends GeometryTestCase {
    public FrechetSimilarityMeasureTest(String name) {
        super(name);
    }

    public void testDifferentGeometryTypesThrowIAE() {
        Geometry g1 = this.read("POINT(1 1)");
        Geometry g2 = this.read("LINESTRING(1 1, 2 1)");
        try {
            FrechetSimilarityMeasure sm = new FrechetSimilarityMeasure();
            sm.measure(g1, g2);
            FrechetSimilarityMeasureTest.fail((String)"Different geometry types should fail!");
        }
        catch (Exception e) {
            FrechetSimilarityMeasureTest.assertTrue((boolean)true);
        }
    }

    public void testEqualGeometriesReturn1() {
        Geometry g1 = this.read("POINT(1 1)");
        Geometry g2 = this.read("POINT(1 1)");
        FrechetSimilarityMeasureTest.assertEquals((String)"Point", (Object)1.0, (Object)new FrechetSimilarityMeasure().measure(g1, g2));
        g1 = this.read("LINESTRING(1 1, 2 1)");
        g2 = this.read("LINESTRING(1 1, 2 1)");
        FrechetSimilarityMeasureTest.assertEquals((String)"LineString", (Object)1.0, (Object)new FrechetSimilarityMeasure().measure(g1, g2));
        g1 = this.read("POLYGON((0 0, 0 10, 10 0, 0 0), (1 1, 7.58 1, 1 7.58, 1 1))");
        g2 = this.read("POLYGON((0 0, 0 10, 10 0, 0 0), (1 1, 7.58 1, 1 7.58, 1 1))");
        FrechetSimilarityMeasureTest.assertEquals((String)"POLYGON", (Object)1.0, (Object)new FrechetSimilarityMeasure().measure(g1, g2));
    }

    public void testGreaterFrechetDistanceReturnsPoorerSimilarity() {
        Geometry g1 = this.read("LINESTRING(1 1, 2 1.0, 3 1)");
        Geometry g2 = this.read("LINESTRING(1 1, 2 1.1, 3 1)");
        Geometry g3 = this.read("LINESTRING(1 1, 2 1.2, 3 1)");
        FrechetSimilarityMeasure sm = new FrechetSimilarityMeasure();
        double m12 = sm.measure(g1, g2);
        double m13 = sm.measure(g1, g3);
        FrechetSimilarityMeasureTest.assertTrue((String)"Greater distance, poorer similarity", (m13 < m12 ? 1 : 0) != 0);
    }
}

