/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.distance;

import junit.framework.TestCase;
import org.locationtech.jts.algorithm.distance.DiscreteFrechetDistance;

public class DiscreteFrechetDistanceDiagonalTest
extends TestCase {
    public DiscreteFrechetDistanceDiagonalTest(String name) {
        super(name);
    }

    public void test1x1() {
        this.checkDiagonal(1, 1, DiscreteFrechetDistanceDiagonalTest.xy(0, 0));
    }

    public void test2x2() {
        this.checkDiagonal(2, 2, DiscreteFrechetDistanceDiagonalTest.xy(0, 0, 1, 1));
    }

    public void test3x3() {
        this.checkDiagonal(3, 3, DiscreteFrechetDistanceDiagonalTest.xy(0, 0, 1, 1, 2, 2));
    }

    public void test3x4() {
        this.checkDiagonal(3, 4, DiscreteFrechetDistanceDiagonalTest.xy(0, 0, 1, 1, 1, 2, 2, 3));
    }

    public void test3x5() {
        this.checkDiagonal(3, 5, DiscreteFrechetDistanceDiagonalTest.xy(0, 0, 0, 1, 1, 2, 1, 3, 2, 4));
    }

    public void test3x6() {
        this.checkDiagonal(3, 6, DiscreteFrechetDistanceDiagonalTest.xy(0, 0, 0, 1, 1, 2, 1, 3, 2, 4, 2, 5));
    }

    public void test6x2() {
        this.checkDiagonal(6, 2, DiscreteFrechetDistanceDiagonalTest.xy(0, 0, 1, 0, 2, 0, 3, 1, 4, 1, 5, 1));
    }

    public void test2x6() {
        this.checkDiagonal(2, 6, DiscreteFrechetDistanceDiagonalTest.xy(0, 0, 0, 1, 0, 2, 1, 3, 1, 4, 1, 5));
    }

    private void checkDiagonal(int cols, int rows, int[] xyExpected) {
        int[] xy = DiscreteFrechetDistance.bresenhamDiagonal(cols, rows);
        DiscreteFrechetDistanceDiagonalTest.assertEquals((int)xyExpected.length, (int)xy.length);
        for (int i = 0; i < xy.length; ++i) {
            DiscreteFrechetDistanceDiagonalTest.assertEquals((int)xyExpected[i], (int)xy[i]);
        }
    }

    private static int[] xy(int ... ord) {
        return ord;
    }
}

