/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.RectangleLineIntersector;
import org.locationtech.jts.algorithm.SimpleRectangleIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

class RectangleLineIntersectorValidator {
    private GeometryFactory geomFact = new GeometryFactory();
    private double baseX = 0.0;
    private double baseY = 0.0;
    private double rectSize = 100.0;
    private Envelope rectEnv;
    private Coordinate[] pts;
    private boolean isValid = true;

    public void init(int nPts) {
        this.rectEnv = this.createRectangle();
        this.pts = this.createTestPoints(nPts);
    }

    public boolean validate() {
        this.run(true, true);
        return this.isValid;
    }

    public void run(boolean useSegInt, boolean useSideInt) {
        RectangleLineIntersector rectSegIntersector = new RectangleLineIntersector(this.rectEnv);
        SimpleRectangleIntersector rectSideIntersector = new SimpleRectangleIntersector(this.rectEnv);
        for (int i = 0; i < this.pts.length; ++i) {
            for (int j = 0; j < this.pts.length; ++j) {
                if (i == j) continue;
                boolean segResult = false;
                if (useSegInt) {
                    segResult = rectSegIntersector.intersects(this.pts[i], this.pts[j]);
                }
                boolean sideResult = false;
                if (useSideInt) {
                    sideResult = rectSideIntersector.intersects(this.pts[i], this.pts[j]);
                }
                if (!useSegInt || !useSideInt || segResult == sideResult) continue;
                this.isValid = false;
            }
        }
    }

    private Coordinate[] createTestPoints(int nPts) {
        Point pt = this.geomFact.createPoint(new Coordinate(this.baseX, this.baseY));
        Geometry circle = pt.buffer(2.0 * this.rectSize, nPts / 4);
        return circle.getCoordinates();
    }

    private Envelope createRectangle() {
        Envelope rectEnv = new Envelope(new Coordinate(this.baseX, this.baseY), new Coordinate(this.baseX + this.rectSize, this.baseY + this.rectSize));
        return rectEnv;
    }
}

