/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

public class PointLocatorTest
extends TestCase {
    private WKTReader reader = new WKTReader();

    public static void main(String[] args) {
        TestRunner.run(PointLocatorTest.class);
    }

    public PointLocatorTest(String name) {
        super(name);
    }

    public void testBox() throws Exception {
        this.runPtLocator(0, new Coordinate(10.0, 10.0), "POLYGON ((0 0, 0 20, 20 20, 20 0, 0 0))");
    }

    public void testComplexRing() throws Exception {
        this.runPtLocator(0, new Coordinate(0.0, 0.0), "POLYGON ((-40 80, -40 -80, 20 0, 20 -100, 40 40, 80 -80, 100 80, 140 -20, 120 140, 40 180,     60 40, 0 120, -20 -20, -40 80))");
    }

    public void testLinearRingLineString() throws Exception {
        this.runPtLocator(1, new Coordinate(0.0, 0.0), "GEOMETRYCOLLECTION( LINESTRING(0 0, 10 10), LINEARRING(10 10, 10 20, 20 10, 10 10))");
    }

    public void testPointInsideLinearRing() throws Exception {
        this.runPtLocator(2, new Coordinate(11.0, 11.0), "LINEARRING(10 10, 10 20, 20 10, 10 10)");
    }

    public void testPolygon() throws Exception {
        PointLocator pointLocator = new PointLocator();
        Geometry polygon = this.reader.read("POLYGON ((70 340, 430 50, 70 50, 70 340))");
        PointLocatorTest.assertEquals((int)2, (int)pointLocator.locate(new Coordinate(420.0, 340.0), polygon));
        PointLocatorTest.assertEquals((int)1, (int)pointLocator.locate(new Coordinate(350.0, 50.0), polygon));
        PointLocatorTest.assertEquals((int)1, (int)pointLocator.locate(new Coordinate(410.0, 50.0), polygon));
        PointLocatorTest.assertEquals((int)0, (int)pointLocator.locate(new Coordinate(190.0, 150.0), polygon));
    }

    private void runPtLocator(int expected, Coordinate pt, String wkt) throws Exception {
        Geometry geom = this.reader.read(wkt);
        PointLocator pointLocator = new PointLocator();
        int loc = pointLocator.locate(pt, geom);
        PointLocatorTest.assertEquals((int)expected, (int)loc);
    }
}

