/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import test.jts.GeometryTestCase;

public class OrientationIsCCWTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(OrientationIsCCWTest.class);
    }

    public OrientationIsCCWTest(String name) {
        super(name);
    }

    public void testTooFewPoints() {
        Coordinate[] pts = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)};
        boolean isCCW = Orientation.isCCW(pts);
        OrientationIsCCWTest.assertTrue((boolean)true);
    }

    public void testCCW() {
        this.checkCCW(true, "POLYGON ((60 180, 140 120, 100 180, 140 240, 60 180))");
    }

    public void testRingCW() {
        this.checkCCW(false, "POLYGON ((60 180, 140 240, 100 180, 140 120, 60 180))");
    }

    public void testCCWSmall() {
        this.checkCCW(true, "POLYGON ((1 1, 9 1, 5 9, 1 1))");
    }

    public void testDuplicateTopPoint() {
        this.checkCCW(true, "POLYGON ((60 180, 140 120, 100 180, 140 240, 140 240, 60 180))");
    }

    public void testFlatTopSegment() {
        this.checkCCW(false, "POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
    }

    public void testFlatMultipleTopSegment() {
        this.checkCCW(false, "POLYGON ((100 200, 127 200, 151 200, 173 200, 200 200, 100 100, 100 200))");
    }

    public void testDegenerateRingHorizontal() {
        this.checkCCW(false, "POLYGON ((100 200, 100 200, 200 200, 100 200))");
    }

    public void testDegenerateRingAngled() {
        this.checkCCW(false, "POLYGON ((100 100, 100 100, 200 200, 100 100))");
    }

    public void testDegenerateRingVertical() {
        this.checkCCW(false, "POLYGON ((200 100, 200 100, 200 200, 200 100))");
    }

    public void testTopAngledSegmentCollapse() {
        this.checkCCW(false, "POLYGON ((10 20, 61 20, 20 30, 50 60, 10 20))");
    }

    public void testABATopFlatSegmentCollapse() {
        this.checkCCW(true, "POLYGON ((71 0, 40 40, 70 40, 40 40, 20 0, 71 0))");
    }

    public void testABATopFlatSegmentCollapseMiddleStart() {
        this.checkCCW(true, "POLYGON ((90 90, 50 90, 10 10, 90 10, 50 90, 90 90))");
    }

    public void testMultipleTopFlatSegmentCollapseSinglePoint() {
        this.checkCCW(true, "POLYGON ((100 100, 200 100, 150 200, 170 200, 200 200, 100 200, 150 200, 100 100))");
    }

    public void testMultipleTopFlatSegmentCollapseFlatTop() {
        this.checkCCW(true, "POLYGON ((10 10, 90 10, 70 70, 90 70, 10 70, 30 70, 50 70, 10 10))");
    }

    public void testBowTieByArea() {
        this.checkCCWArea(true, "POLYGON ((10 10, 50 10, 25 35, 35 35, 10 10))");
    }

    private void checkCCW(boolean expectedCCW, String wkt) {
        Coordinate[] pts2x = this.getCoordinates(wkt);
        OrientationIsCCWTest.assertEquals((String)"Coordinate array isCCW: ", (boolean)expectedCCW, (boolean)Orientation.isCCW(pts2x));
        CoordinateSequence seq2x = this.getCoordinateSequence(wkt);
        OrientationIsCCWTest.assertEquals((String)"CoordinateSequence isCCW: ", (boolean)expectedCCW, (boolean)Orientation.isCCW(seq2x));
    }

    private void checkCCWArea(boolean expectedCCW, String wkt) {
        Coordinate[] pts = this.getCoordinates(wkt);
        OrientationIsCCWTest.assertEquals((String)"Coordinate array isCCW: ", (boolean)expectedCCW, (boolean)Orientation.isCCWArea(pts));
    }

    private Coordinate[] getCoordinates(String wkt) {
        Geometry geom = this.read(wkt);
        return geom.getCoordinates();
    }

    private CoordinateSequence getCoordinateSequence(String wkt) {
        Geometry geom = this.read(wkt);
        if (geom.getGeometryType() != "Polygon") {
            throw new IllegalArgumentException("wkt");
        }
        Polygon poly = (Polygon)geom;
        return ((Polygon)geom).getExteriorRing().getCoordinateSequence();
    }
}

