/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTFileReader;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.util.Stopwatch;
import test.jts.GeometryTestCase;
import test.jts.TestFiles;

public class InteriorPointTest
extends GeometryTestCase {
    WKTReader rdr = new WKTReader();

    public static void main(String[] args) {
        TestRunner.run(InteriorPointTest.class);
    }

    public InteriorPointTest(String name) {
        super(name);
    }

    public void testPolygonZeroArea() {
        this.checkInteriorPoint(this.read("POLYGON ((10 10, 10 10, 10 10, 10 10))"), new Coordinate(10.0, 10.0));
    }

    public void testAll() throws Exception {
        this.checkInteriorPointFile(TestFiles.getResourceFilePath("world.wkt"));
    }

    void checkInteriorPointFile(String file) throws Exception {
        WKTFileReader fileRdr = new WKTFileReader(new FileReader(file), this.rdr);
        this.checkInteriorPointFile(fileRdr);
    }

    void checkInteriorPointResource(String resource) throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        WKTFileReader fileRdr = new WKTFileReader(new InputStreamReader(is), this.rdr);
        this.checkInteriorPointFile(fileRdr);
    }

    private void checkInteriorPointFile(WKTFileReader fileRdr) throws IOException, ParseException {
        List polys = fileRdr.read();
        this.checkInteriorPoint(polys);
    }

    void checkInteriorPoint(List geoms) {
        Stopwatch sw = new Stopwatch();
        for (Geometry g : geoms) {
            this.checkInteriorPoint(g);
            System.out.print(".");
        }
    }

    private void checkInteriorPoint(Geometry g) {
        Point ip = g.getInteriorPoint();
        InteriorPointTest.assertTrue((boolean)g.contains(ip));
    }

    private void checkInteriorPoint(Geometry g, Coordinate expectedPt) {
        Point ip = g.getInteriorPoint();
        InteriorPointTest.assertTrue((boolean)ip.getCoordinate().equals2D(expectedPt));
    }
}

