/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.buildings_tools;

import javax.swing.Action;
import javax.swing.JMenu;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.buildings_tools.BuildingCircleAction;
import org.openstreetmap.josm.plugins.buildings_tools.BuildingRectangleAction;
import org.openstreetmap.josm.plugins.buildings_tools.BuildingSizeAction;
import org.openstreetmap.josm.plugins.buildings_tools.DrawBuildingAction;
import org.openstreetmap.josm.plugins.buildings_tools.MergeAddrPointsAction;

public class BuildingsToolsPlugin
extends Plugin {
    public static final Projection MERCATOR = Projections.getProjectionByCode((String)"EPSG:3857");

    public static EastNorth latlon2eastNorth(ILatLon p) {
        return MERCATOR.latlon2eastNorth(p);
    }

    public static LatLon eastNorth2latlon(EastNorth p) {
        return MERCATOR.eastNorth2latlon(p);
    }

    public BuildingsToolsPlugin(PluginInformation info) {
        super(info);
        JMenu dataMenu = MainApplication.getMenu().dataMenu;
        MainMenu.add((JMenu)dataMenu, (JosmAction)new BuildingSizeAction());
        MainMenu.add((JMenu)dataMenu, (JosmAction)new BuildingCircleAction());
        MainMenu.add((JMenu)dataMenu, (JosmAction)new BuildingRectangleAction());
        MainMenu.add((JMenu)dataMenu, (JosmAction)new MergeAddrPointsAction());
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            MainApplication.getMap().addMapMode(new IconToggleButton((Action)((Object)new DrawBuildingAction())));
        }
    }
}

