/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;

public class OpenLinkAction
extends JosmAction {
    private URL url;

    public OpenLinkAction(URL url, String icon24Name, String title, String description) {
        super(title, null, description, null, false);
        this.putValue("SmallIcon", OdUtils.getImageIcon(icon24Name));
        this.url = url;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Logging.info((String)("Opening " + this.url));
            OpenBrowser.displayUrl((URI)this.url.toURI());
        }
        catch (URISyntaxException e1) {
            try {
                Logging.error((String)e1.getLocalizedMessage());
                int index = e1.getIndex();
                if (index > -1) {
                    String s = this.url.toString().substring(index, index + 1);
                    s = this.url.toString().replace(s, URLEncoder.encode(s, "UTF-8"));
                    URI uri = new URI(s);
                    Logging.info((String)("Opening " + uri));
                    OpenBrowser.displayUrl((URI)uri);
                }
            }
            catch (IOException | URISyntaxException e2) {
                Logging.error((Throwable)e2);
            }
        }
    }
}

