/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.regex.Matcher;
import org.apache.poi.ss.format.CellFormatPart;
import org.apache.poi.ss.format.CellFormatType;
import org.apache.poi.ss.format.CellFormatter;

public class CellDateFormatter
extends CellFormatter {
    private boolean amPmUpper;
    private boolean showM;
    private boolean showAmPm;
    private final DateFormat dateFmt;
    private String sFmt;
    private static final long EXCEL_EPOCH_TIME;
    private static final Date EXCEL_EPOCH_DATE;
    private static final CellFormatter SIMPLE_DATE;

    public CellDateFormatter(String string) {
        super(string);
        DatePartHandler datePartHandler = new DatePartHandler();
        StringBuffer stringBuffer = CellFormatPart.parseFormat(string, CellFormatType.DATE, datePartHandler);
        datePartHandler.finish(stringBuffer);
        this.dateFmt = new SimpleDateFormat(stringBuffer.toString());
    }

    @Override
    public void formatValue(StringBuffer stringBuffer, Object object) {
        Object object2;
        if (object == null) {
            object = 0.0;
        }
        if (object instanceof Number) {
            object2 = (Number)object;
            double d = ((Number)object2).doubleValue();
            object = d == 0.0 ? EXCEL_EPOCH_DATE : new Date((long)((double)EXCEL_EPOCH_TIME + d));
        }
        object2 = this.dateFmt.formatToCharacterIterator(object);
        boolean bl = false;
        boolean bl2 = false;
        object2.first();
        char c = object2.first();
        while (c != '\uffff') {
            if (object2.getAttribute(DateFormat.Field.MILLISECOND) != null) {
                if (!bl2) {
                    Date date = (Date)object;
                    int n = stringBuffer.length();
                    Formatter formatter = new Formatter(stringBuffer);
                    long l = date.getTime() % 1000L;
                    formatter.format(LOCALE, this.sFmt, (double)l / 1000.0);
                    stringBuffer.delete(n, n + 2);
                    bl2 = true;
                }
            } else if (object2.getAttribute(DateFormat.Field.AM_PM) != null) {
                if (!bl) {
                    if (this.showAmPm) {
                        if (this.amPmUpper) {
                            stringBuffer.append(Character.toUpperCase(c));
                            if (this.showM) {
                                stringBuffer.append('M');
                            }
                        } else {
                            stringBuffer.append(Character.toLowerCase(c));
                            if (this.showM) {
                                stringBuffer.append('m');
                            }
                        }
                    }
                    bl = true;
                }
            } else {
                stringBuffer.append(c);
            }
            c = object2.next();
        }
    }

    @Override
    public void simpleValue(StringBuffer stringBuffer, Object object) {
        SIMPLE_DATE.formatValue(stringBuffer, object);
    }

    static {
        SIMPLE_DATE = new CellDateFormatter("mm/d/y");
        Calendar calendar = Calendar.getInstance();
        calendar.set(1904, 0, 1, 0, 0, 0);
        EXCEL_EPOCH_DATE = calendar.getTime();
        EXCEL_EPOCH_TIME = calendar.getTimeInMillis();
    }

    private class DatePartHandler
    implements CellFormatPart.PartHandler {
        private int mStart = -1;
        private int mLen;
        private int hStart = -1;
        private int hLen;

        private DatePartHandler() {
        }

        @Override
        public String handlePart(Matcher matcher, String string, CellFormatType cellFormatType, StringBuffer stringBuffer) {
            int n = stringBuffer.length();
            char c = string.charAt(0);
            switch (c) {
                case 'S': 
                case 's': {
                    if (this.mStart >= 0) {
                        for (int i = 0; i < this.mLen; ++i) {
                            stringBuffer.setCharAt(this.mStart + i, 'm');
                        }
                        this.mStart = -1;
                    }
                    return string.toLowerCase();
                }
                case 'H': 
                case 'h': {
                    this.mStart = -1;
                    this.hStart = n;
                    this.hLen = string.length();
                    return string.toLowerCase();
                }
                case 'D': 
                case 'd': {
                    this.mStart = -1;
                    if (string.length() <= 2) {
                        return string.toLowerCase();
                    }
                    return string.toLowerCase().replace('d', 'E');
                }
                case 'M': 
                case 'm': {
                    this.mStart = n;
                    this.mLen = string.length();
                    return string.toUpperCase();
                }
                case 'Y': 
                case 'y': {
                    this.mStart = -1;
                    if (string.length() == 3) {
                        string = "yyyy";
                    }
                    return string.toLowerCase();
                }
                case '0': {
                    this.mStart = -1;
                    int n2 = string.length();
                    CellDateFormatter.this.sFmt = "%0" + (n2 + 2) + "." + n2 + "f";
                    return string.replace('0', 'S');
                }
                case 'A': 
                case 'P': 
                case 'a': 
                case 'p': {
                    if (string.length() <= 1) break;
                    this.mStart = -1;
                    CellDateFormatter.this.showAmPm = true;
                    CellDateFormatter.this.showM = Character.toLowerCase(string.charAt(1)) == 'm';
                    CellDateFormatter.this.amPmUpper = CellDateFormatter.this.showM || Character.isUpperCase(string.charAt(0));
                    return "a";
                }
            }
            return null;
        }

        public void finish(StringBuffer stringBuffer) {
            if (this.hStart >= 0 && !CellDateFormatter.this.showAmPm) {
                for (int i = 0; i < this.hLen; ++i) {
                    stringBuffer.setCharAt(this.hStart + i, 'H');
                }
            }
        }
    }
}

