/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.record.Record;

public final class WorkbookRecordList
implements Iterable<Record> {
    private List<Record> records = new ArrayList<Record>();
    private int protpos = 0;
    private int bspos = 0;
    private int tabpos = 0;
    private int xfpos = 0;
    private int namepos = 0;
    private int supbookpos = 0;
    private int externsheetPos = 0;
    private int palettepos = -1;

    public void setRecords(List<Record> list) {
        this.records = list;
    }

    public int size() {
        return this.records.size();
    }

    public Record get(int n) {
        return this.records.get(n);
    }

    public void add(int n, Record record) {
        this.records.add(n, record);
        if (this.getProtpos() >= n) {
            this.setProtpos(this.protpos + 1);
        }
        if (this.getBspos() >= n) {
            this.setBspos(this.bspos + 1);
        }
        if (this.getTabpos() >= n) {
            this.setTabpos(this.tabpos + 1);
        }
        if (this.getXfpos() >= n) {
            this.setXfpos(this.xfpos + 1);
        }
        if (this.getNamepos() >= n) {
            this.setNamepos(this.namepos + 1);
        }
        if (this.getSupbookpos() >= n) {
            this.setSupbookpos(this.supbookpos + 1);
        }
        if (this.getPalettepos() != -1 && this.getPalettepos() >= n) {
            this.setPalettepos(this.palettepos + 1);
        }
        if (this.getExternsheetPos() >= n) {
            this.setExternsheetPos(this.getExternsheetPos() + 1);
        }
    }

    public List<Record> getRecords() {
        return this.records;
    }

    @Override
    public Iterator<Record> iterator() {
        return this.records.iterator();
    }

    public int getProtpos() {
        return this.protpos;
    }

    public void setProtpos(int n) {
        this.protpos = n;
    }

    public int getBspos() {
        return this.bspos;
    }

    public void setBspos(int n) {
        this.bspos = n;
    }

    public int getTabpos() {
        return this.tabpos;
    }

    public void setTabpos(int n) {
        this.tabpos = n;
    }

    public int getXfpos() {
        return this.xfpos;
    }

    public void setXfpos(int n) {
        this.xfpos = n;
    }

    public int getPalettepos() {
        return this.palettepos;
    }

    public void setPalettepos(int n) {
        this.palettepos = n;
    }

    public int getNamepos() {
        return this.namepos;
    }

    public int getSupbookpos() {
        return this.supbookpos;
    }

    public void setNamepos(int n) {
        this.namepos = n;
    }

    public void setSupbookpos(int n) {
        this.supbookpos = n;
    }

    public int getExternsheetPos() {
        return this.externsheetPos;
    }

    public void setExternsheetPos(int n) {
        this.externsheetPos = n;
    }
}

