/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.OsmUtils;
import org.openstreetmap.josm.plugins.fixAddresses.StringUtils;

public class GuessedValueHandler
implements OsmPrimitiveVisitor {
    private static final double DEFAULT_MAX_DIST = 100.0;
    private String tag;
    protected double minDist;
    protected String currentValue;
    private OSMAddress aNode;
    private double maxDist = 100.0;
    protected OsmPrimitive srcNode;

    public GuessedValueHandler(String tag) {
        this(tag, null, 100.0);
    }

    public GuessedValueHandler(String tag, double maxDist) {
        this(tag, null, maxDist);
    }

    public GuessedValueHandler(String tag, OSMAddress aNode) {
        this(tag, aNode, 100.0);
    }

    public GuessedValueHandler(String tag, OSMAddress aNode, double maxDist) {
        if (StringUtils.isNullOrEmpty(tag)) {
            throw new RuntimeException("Tag must not be empty or null!");
        }
        if (maxDist < 1.0) {
            maxDist = 1.0;
        }
        this.tag = tag;
        this.maxDist = maxDist;
        this.setAddressNode(aNode);
    }

    protected OSMAddress getAddressNode() {
        return this.aNode;
    }

    public void setAddressNode(OSMAddress aNode) {
        this.aNode = aNode;
        this.minDist = Double.MAX_VALUE;
        this.srcNode = null;
        this.currentValue = null;
    }

    protected double getMaxDistance() {
        return this.maxDist;
    }

    protected String getTag() {
        return this.tag;
    }

    protected double getMinimumDist() {
        return this.minDist;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public OsmPrimitive getSourceNode() {
        return this.srcNode;
    }

    public boolean needsGuess() {
        return this.aNode.needsGuessedValue(this.tag);
    }

    public void visit(Node n) {
        double dist;
        assert (this.aNode != null);
        if (n.hasKey(this.tag) && (dist = n.greatCircleDistance((ILatLon)this.aNode.getCoor())) < this.minDist && dist < this.maxDist) {
            this.minDist = dist;
            this.currentValue = n.get(this.tag);
            this.srcNode = n;
        }
    }

    public void visit(Way w) {
        double dist;
        assert (this.aNode != null);
        if (w.hasKey(this.tag) && (dist = OsmUtils.getMinimumDistanceToWay(this.aNode.getCoor(), w)) < this.minDist && dist < this.maxDist) {
            this.minDist = dist;
            this.currentValue = w.get(this.tag);
            this.srcNode = w;
        }
    }

    public void visit(Relation e) {
    }
}

