/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.relate;

import java.io.PrintStream;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;
import test.jts.util.IOUtil;

public class RelateMonotoneLinesPerfTest
extends PerformanceTestCase {
    private static final int DENSIFY_FACTOR = 1000;
    LineString line1;
    LineString line2;

    public static void main(String[] args) {
        PerformanceTestRunner.run(RelateMonotoneLinesPerfTest.class);
    }

    public RelateMonotoneLinesPerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512});
        this.setRunIterations(1);
    }

    @Override
    public void startRun(int runSize) {
        int nVertices = runSize * 1000;
        this.line1 = this.createLine("LINESTRING (0 0, 100 100)", nVertices);
        this.line2 = this.createLine("LINESTRING (0 1, 100 99)", nVertices);
        this.line1.intersects(this.line2);
    }

    private LineString createLine(String wkt, int nVertices) {
        double distanceTolerance = 100.0 / (double)nVertices;
        Geometry line = IOUtil.read(wkt);
        LineString lineDense = (LineString)Densifier.densify(line, distanceTolerance);
        return lineDense;
    }

    public void runIntersects() {
        System.out.println("Line size: " + this.line2.getNumPoints());
        boolean isIntersects = this.line1.intersects(this.line2);
    }

    @Override
    public void tearDown() {
        double[] timeFactor = this.computeTimeFactors();
        System.out.print("Time factors: ");
        this.printArray(timeFactor, System.out);
        System.out.println();
    }

    private void printArray(double[] timeFactor, PrintStream out) {
        for (double d : timeFactor) {
            out.print(d + " ");
        }
    }

    private double[] computeTimeFactors() {
        long[] runTime = this.getRunTime();
        double[] timeFactor = new double[runTime.length - 1];
        for (int i = 0; i < runTime.length - 1; ++i) {
            timeFactor[i] = (double)runTime[i + 1] / (double)runTime[i];
        }
        return timeFactor;
    }
}

