/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.distance;

import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTFileReader;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.util.Stopwatch;
import test.jts.perf.operation.distance.CachedFastDistance;

public class TestPerfFastDistanceFile {
    private static final int MAX_GEOMS = 40;
    boolean testFailed = false;
    static final int MAX_ITER = 10;

    public static void main(String[] args) {
        TestPerfFastDistanceFile test = new TestPerfFastDistanceFile();
        try {
            test.test();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void test() throws Exception {
        List geoms = TestPerfFastDistanceFile.loadWKT("C:\\data\\martin\\proj\\jts\\sandbox\\jts\\testdata\\world.wkt");
        this.testAllDistances(geoms, 1);
        this.testAllDistances(geoms, 2);
        this.testAllDistances(geoms, 5);
        this.testAllDistances(geoms, 10);
        this.testAllDistances(geoms, 20);
        this.testAllDistances(geoms, 30);
        this.testAllDistances(geoms, 40);
        this.testAllDistances(geoms, 50);
    }

    static List loadWKT(String filename) throws Exception {
        WKTReader rdr = new WKTReader();
        WKTFileReader fileRdr = new WKTFileReader(filename, rdr);
        return fileRdr.read();
    }

    void testAllDistances(List geoms, int maxToScan) {
        Stopwatch sw = new Stopwatch();
        this.computeAllDistances(geoms, maxToScan);
        System.out.println("Count = " + maxToScan + "   Finished in " + sw.getTimeString());
    }

    void computeAllDistances(List geoms, int maxToScan) {
        int numGeoms1 = geoms.size();
        if (numGeoms1 > maxToScan) {
            numGeoms1 = maxToScan;
        }
        int numGeoms2 = geoms.size();
        for (int i = 0; i < numGeoms1; ++i) {
            for (int j = 0; j < numGeoms2; ++j) {
                Geometry g1 = (Geometry)geoms.get(i);
                Geometry g2 = (Geometry)geoms.get(j);
                double d = CachedFastDistance.getDistance(g1, g2);
            }
        }
    }

    void computePairDistance(List geoms, int i, int j) {
        for (int n = 0; n < 10; ++n) {
            Geometry g1 = (Geometry)geoms.get(i);
            Geometry g2 = (Geometry)geoms.get(j);
            double d = g1.distance(g2);
        }
    }
}

