/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.distance;

import java.util.List;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTFileReader;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.distance.IndexedFacetDistance;
import org.locationtech.jts.util.Stopwatch;

public class TestPerfDistanceLinesPoints {
    static final boolean USE_INDEXED_DIST = true;
    static GeometryFactory geomFact = new GeometryFactory();
    static final int MAX_ITER = 1;
    static final int NUM_TARGET_ITEMS = 4000;
    static final double EXTENT = 1000.0;
    static final int NUM_PTS_SIDE = 100;
    boolean verbose = true;

    public static void main(String[] args) {
        TestPerfDistanceLinesPoints test = new TestPerfDistanceLinesPoints();
        try {
            test.test();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void test() throws Exception {
        this.test(100);
        this.test(200);
        this.test(500);
        this.test(1000);
    }

    public void test(int num) throws Exception {
        Geometry target = this.createDiagonalCircles(1000.0, 4000);
        Geometry[] pts = this.createPoints(target.getEnvelopeInternal(), num);
        this.test(pts, target);
    }

    public void xtest(int num) throws Exception {
        Geometry target = this.loadData("C:\\proj\\JTS\\test\\g2e\\ffmwdec08.wkt");
        Envelope bcEnv_Albers = new Envelope(-45838.0, 1882064.0, 255756.0, 1733287.0);
        Geometry[] pts = this.createPoints(bcEnv_Albers, num);
        this.test(pts, target, true);
    }

    public void test(Geometry[] pts, Geometry target) {
        if (this.verbose) {
            System.out.println();
            System.out.println("Query points = " + pts.length + "     Target points = " + target.getNumPoints());
        }
        this.test(pts, target, true);
        this.test(pts, target, false);
    }

    public void test(Geometry[] pts, Geometry target, boolean useFastDist) {
        Stopwatch sw = new Stopwatch();
        double dist = 0.0;
        for (int i = 0; i < 1; ++i) {
            this.computeDistance(pts, target);
        }
        if (!this.verbose) {
            System.out.println(sw.getTimeString());
        }
        if (this.verbose) {
            String name = useFastDist ? "IndexedFacetDistance" : "Distance";
            System.out.println(name + " - Run time: " + sw.getTimeString());
        }
    }

    void computeDistance(Geometry[] pts, Geometry geom) {
        IndexedFacetDistance bbd = null;
        bbd = new IndexedFacetDistance(geom);
        for (int i = 0; i < pts.length; ++i) {
            double d = bbd.distance(pts[i]);
        }
    }

    Geometry createDiagonalCircles(double extent, int nSegs) {
        Polygon[] circles = new Polygon[nSegs];
        double inc = extent / (double)nSegs;
        for (int i = 0; i < nSegs; ++i) {
            double ord = (double)i * inc;
            Coordinate p = new Coordinate(ord, ord);
            Point pt = geomFact.createPoint(p);
            circles[i] = (Polygon)pt.buffer(inc / 2.0);
        }
        return geomFact.createMultiPolygon(circles);
    }

    Geometry createLine(double extent, int nSegs) {
        Coordinate[] pts = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, extent), new Coordinate(extent, extent), new Coordinate(extent, 0.0)};
        LineString outline = geomFact.createLineString(pts);
        double inc = extent / (double)nSegs;
        return Densifier.densify(outline, inc);
    }

    Geometry createDiagonalLine(double extent, int nSegs) {
        Coordinate[] pts = new Coordinate[nSegs + 1];
        pts[0] = new Coordinate(0.0, 0.0);
        double inc = extent / (double)nSegs;
        for (int i = 1; i <= nSegs; ++i) {
            double ord = (double)i * inc;
            pts[i] = new Coordinate(ord, ord);
        }
        return geomFact.createLineString(pts);
    }

    Geometry[] createPoints(Envelope extent, int nPtsSide) {
        Geometry[] pts = new Geometry[nPtsSide * nPtsSide];
        int index = 0;
        double xinc = extent.getWidth() / (double)nPtsSide;
        double yinc = extent.getHeight() / (double)nPtsSide;
        for (int i = 0; i < nPtsSide; ++i) {
            for (int j = 0; j < nPtsSide; ++j) {
                pts[index++] = geomFact.createPoint(new Coordinate(extent.getMinX() + (double)i * xinc, extent.getMinY() + (double)j * yinc));
            }
        }
        return pts;
    }

    Geometry loadData(String file) throws Exception {
        List geoms = this.loadWKT(file);
        return geomFact.buildGeometry(geoms);
    }

    List loadWKT(String filename) throws Exception {
        WKTReader rdr = new WKTReader();
        WKTFileReader fileRdr = new WKTFileReader(filename, rdr);
        return fileRdr.read();
    }
}

