/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.index;

import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.hprtree.HPRtree;
import org.locationtech.jts.util.Stopwatch;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;
import test.jts.perf.index.CountItemVisitor;

public class HPRtreePerfTest
extends PerformanceTestCase {
    private static final int NODE_SIZE = 32;
    private static final int ITEM_ENV_SIZE = 10;
    private static final int QUERY_ENV_SIZE = 40;
    private HPRtree index;

    public static void main(String[] args) {
        PerformanceTestRunner.run(HPRtreePerfTest.class);
    }

    public HPRtreePerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{100, 10000, 100000});
        this.setRunIterations(1);
    }

    @Override
    public void setUp() {
    }

    @Override
    public void startRun(int size) {
        System.out.println("----- Tree size: " + size);
        this.index = new HPRtree(32);
        int side = (int)Math.sqrt(size);
        HPRtreePerfTest.loadGrid(side, this.index);
        Stopwatch sw = new Stopwatch();
        this.index.build();
        System.out.println("Build time = " + sw.getTimeString());
    }

    private static void loadGrid(int side, SpatialIndex index) {
        for (int i = 0; i < side; ++i) {
            for (int j = 0; j < side; ++j) {
                Envelope env = new Envelope(i, i + 10, j, j + 10);
                index.insert(env, i + "-" + j);
            }
        }
    }

    public void runQueries() {
        CountItemVisitor visitor = new CountItemVisitor();
        int size = this.index.size();
        int side = (int)Math.sqrt(size);
        for (int i = 0; i < side; ++i) {
            for (int j = 0; j < side; ++j) {
                Envelope env = new Envelope(i, i + 40, j, j + 40);
                this.index.query(env, visitor);
            }
        }
        System.out.println("Total query result items = " + visitor.count);
    }
}

