/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.geom.util;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.util.GeometryFixer;

public class GeometryFixerFuzzer {
    private static final int NUM_ITER = 10000;
    public GeometryFactory factory = new GeometryFactory();

    public static void main(String[] args) {
        GeometryFixerFuzzer.run();
    }

    private static void run() {
        GeometryFixerFuzzer fuzzer = new GeometryFixerFuzzer();
        fuzzer.run(10000);
    }

    private void run(int numIter) {
        for (int i = 0; i < numIter; ++i) {
            int numHoles = (int)(10.0 * Math.random());
            Geometry invalidPoly = this.createRandomPoly(100, numHoles);
            Geometry result = GeometryFixer.fix(invalidPoly);
            boolean isValid = result.isValid();
            String status = isValid ? "valid" : "INVALID";
            String msg = String.format("%d: Pts - input %d, output %d - %s", i, invalidPoly.getNumPoints(), result.getNumPoints(), status);
            if (isValid) continue;
            System.out.println(msg);
            System.out.println(invalidPoly);
        }
    }

    private Geometry createRandomPoly(int numPoints, int numHoles) {
        int numRingPoints = numPoints / (numHoles + 1);
        LinearRing shell = this.createRandomRing(numRingPoints);
        LinearRing[] holes = new LinearRing[numHoles];
        for (int i = 0; i < numHoles; ++i) {
            holes[i] = this.createRandomRing(numRingPoints);
        }
        return this.factory.createPolygon(shell, holes);
    }

    private LinearRing createRandomRing(int numPoints) {
        return this.factory.createLinearRing(this.createRandomPoints(numPoints));
    }

    private Coordinate[] createRandomPoints(int numPoints) {
        Coordinate[] pts = new Coordinate[numPoints + 1];
        for (int i = 0; i < numPoints; ++i) {
            Coordinate p;
            pts[i] = p = new Coordinate(this.randOrd(), this.randOrd());
        }
        pts[pts.length - 1] = pts[0].copy();
        return pts;
    }

    private double randOrd() {
        double ord = 100.0 * Math.random();
        return ord;
    }
}

