/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.NonRobustRayCrossingCounter;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.io.WKTWriter;
import test.jts.GeometryTestCase;

public class PointInRingRobustnessTest
extends GeometryTestCase {
    private boolean isAllConsistent = true;
    private int testCount;
    private int failureCount;

    public static void main(String[] args) {
        TestRunner.run(PointInRingRobustnessTest.class);
    }

    public PointInRingRobustnessTest(String name) {
        super(name);
    }

    public void init() {
        this.testCount = 0;
        this.failureCount = 0;
        this.isAllConsistent = true;
    }

    public void testRightTriangles() {
        this.init();
        this.checkRightTriangles(200.0, 100.0, 1000);
        System.out.println("Tests: " + this.testCount + "   Failures: " + this.failureCount);
        PointInRingRobustnessTest.assertTrue((boolean)this.isAllConsistent);
    }

    public void XtestRandomTriangles() {
        this.init();
        this.checkRandomTriangles(1000, 100, 100);
        System.out.println("Tests: " + this.testCount + "   Failures: " + this.failureCount);
        PointInRingRobustnessTest.assertTrue((boolean)this.isAllConsistent);
    }

    private void checkRandomTriangles(int sideLen, int numTris, int numEdgePts) {
        for (int i = 0; i < numTris; ++i) {
            Coordinate start = new Coordinate(PointInRingRobustnessTest.randomInt(sideLen), PointInRingRobustnessTest.randomInt(sideLen));
            Coordinate[] triPts = new Coordinate[]{start, new Coordinate(PointInRingRobustnessTest.randomInt(sideLen), PointInRingRobustnessTest.randomInt(sideLen)), new Coordinate(PointInRingRobustnessTest.randomInt(sideLen), PointInRingRobustnessTest.randomInt(sideLen)), new Coordinate(start)};
            this.checkTriangleEdgePoints(triPts, numEdgePts);
        }
    }

    private static int randomInt(int max) {
        return (int)(Math.random() * (double)max);
    }

    private void checkRightTriangles(double maxHeight, double width, int numEdgePts) {
        int height = 0;
        while ((double)height < maxHeight) {
            Coordinate[] triPts = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, height), new Coordinate(width, 0.0), new Coordinate(0.0, 0.0)};
            this.checkTriangleEdgePoints(triPts, numEdgePts);
            ++height;
        }
    }

    public void checkTriangleEdgePoints(Coordinate[] triPts, int numEdgePts) {
        for (int i = 0; i < numEdgePts; ++i) {
            double lenFrac = (double)i / (double)(numEdgePts + 1);
            this.checkTriangleConsistent(triPts, lenFrac);
        }
    }

    boolean checkTriangleConsistent(Coordinate[] triPts, double lenFraction) {
        boolean isConsistent;
        ++this.testCount;
        LineSegment seg = new LineSegment(triPts[1], triPts[2]);
        Coordinate pt = seg.pointAlong(lenFraction);
        boolean isPointInRing = 0 == NonRobustRayCrossingCounter.locatePointInRing(pt, triPts);
        int orientation = Orientation.index(triPts[1], triPts[2], pt);
        if (Orientation.isCCW(triPts)) {
            orientation = -orientation;
        }
        if (orientation == 0) {
            return true;
        }
        boolean bothOutside = !isPointInRing && orientation == 1;
        boolean bothInside = isPointInRing && orientation == -1;
        boolean bl = isConsistent = bothOutside || bothInside;
        if (!isConsistent) {
            this.isAllConsistent = false;
            ++this.failureCount;
            System.out.println("Inconsistent: PIR=" + isPointInRing + " Orient=" + orientation + "  Pt: " + WKTWriter.toPoint(pt) + "  seg: " + WKTWriter.toLineString(triPts[1], triPts[2]) + "  tri: " + PointInRingRobustnessTest.toPolygon(triPts));
        }
        return isConsistent;
    }

    public static String toPolygon(Coordinate[] coord) {
        StringBuffer buf = new StringBuffer();
        buf.append("POLYGON ");
        if (coord.length == 0) {
            buf.append(" EMPTY");
        } else {
            buf.append("((");
            for (int i = 0; i < coord.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(coord[i].x + " " + coord[i].y);
            }
            buf.append("))");
        }
        return buf.toString();
    }

    private static boolean pointInRingWindingNumber(Coordinate p, Coordinate[] ring) {
        int winding = 0;
        int n = ring.length;
        for (int i = 0; i < n - 1; ++i) {
            if (ring[i].y <= p.y) {
                if (!(ring[i + 1].y > p.y) || 1 != Orientation.index(ring[i], ring[i + 1], p)) continue;
                ++winding;
                continue;
            }
            if (!(ring[i + 1].y <= p.y) || -1 != Orientation.index(ring[i], ring[i + 1], p)) continue;
            --winding;
        }
        return winding != 0;
    }
}

