/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relate;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.relate.RelateOp;

public class RelateTest
extends TestCase {
    private GeometryFactory fact = new GeometryFactory();
    private WKTReader rdr = new WKTReader(this.fact);

    public static void main(String[] args) {
        TestRunner.run(RelateTest.class);
    }

    public RelateTest(String name) {
        super(name);
    }

    public void testContainsIncorrectIMMatrix() throws Exception {
        String a = "LINESTRING (1 0, 0 2, 0 0, 2 2)";
        String b = "LINESTRING (0 0, 2 2)";
        this.runRelateTest(a, b, "001F001F2");
    }

    void runRelateTest(String wkt1, String wkt2, String expectedIM) throws ParseException {
        Geometry g1 = this.rdr.read(wkt1);
        Geometry g2 = this.rdr.read(wkt2);
        IntersectionMatrix im = RelateOp.relate(g1, g2);
        String imStr = im.toString();
        RelateTest.assertTrue((boolean)im.matches(expectedIM));
    }
}

