/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relate;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.relate.RelateOp;

public class RelateBoundaryNodeRuleTest
extends TestCase {
    private GeometryFactory fact = new GeometryFactory();
    private WKTReader rdr = new WKTReader(this.fact);

    public static void main(String[] args) {
        TestRunner.run(RelateBoundaryNodeRuleTest.class);
    }

    public RelateBoundaryNodeRuleTest(String name) {
        super(name);
    }

    public void testMultiLineStringSelfIntTouchAtEndpoint() throws Exception {
        String a = "MULTILINESTRING ((20 20, 100 100, 100 20, 20 100), (60 60, 60 140))";
        String b = "LINESTRING (60 60, 20 60)";
        this.runRelateTest(a, b, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, "FF1F00102");
    }

    public void testLineStringSelfIntTouchAtEndpoint() throws Exception {
        String a = "LINESTRING (20 20, 100 100, 100 20, 20 100)";
        String b = "LINESTRING (60 60, 20 60)";
        this.runRelateTest(a, b, BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE, "F01FF0102");
        this.runRelateTest(a, b, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, "F01FF0102");
    }

    public void testMultiLineStringTouchAtEndpoint() throws Exception {
        String a = "MULTILINESTRING ((0 0, 10 10), (10 10, 20 20))";
        String b = "LINESTRING (10 10, 20 0)";
        this.runRelateTest(a, b, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, "FF1F00102");
    }

    public void testLineRingTouchAtEndpoints() throws Exception {
        String a = "LINESTRING (20 100, 20 220, 120 100, 20 100)";
        String b = "LINESTRING (20 20, 20 100)";
        this.runRelateTest(a, b, BoundaryNodeRule.MULTIVALENT_ENDPOINT_BOUNDARY_RULE, "0F1FFF1F2");
    }

    public void testLineRingTouchAtEndpointAndInterior() throws Exception {
        String a = "LINESTRING (20 100, 20 220, 120 100, 20 100)";
        String b = "LINESTRING (20 20, 40 100)";
        this.runRelateTest(a, b, BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE, "F01FFF102");
        this.runRelateTest(a, b, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, "F01FF0102");
    }

    public void testPolygonEmptyRing() throws Exception {
        String a = "POLYGON EMPTY";
        String b = "LINESTRING (20 100, 20 220, 120 100, 20 100)";
        this.runRelateTest(a, b, BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE, "FFFFFF1F2");
        this.runRelateTest(a, b, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, "FFFFFF102");
    }

    public void testPolygonEmptyMultiLineStringClosed() throws Exception {
        String a = "POLYGON EMPTY";
        String b = "MULTILINESTRING ((0 0, 0 1), (0 1, 1 1, 1 0, 0 0))";
        this.runRelateTest(a, b, BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE, "FFFFFF1F2");
        this.runRelateTest(a, b, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, "FFFFFF102");
    }

    void runRelateTest(String wkt1, String wkt2, BoundaryNodeRule bnRule, String expectedIM) throws ParseException {
        Geometry g1 = this.rdr.read(wkt1);
        Geometry g2 = this.rdr.read(wkt2);
        IntersectionMatrix im = RelateOp.relate(g1, g2, bnRule);
        String imStr = im.toString();
        RelateBoundaryNodeRuleTest.assertTrue((String)("Expected " + expectedIM + ", found " + im), (boolean)im.matches(expectedIM));
    }
}

