/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.ValidatingNoder;
import org.locationtech.jts.noding.snap.SnappingNoder;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import test.jts.GeometryTestCase;

public class OverlayNGSnappingTestOne
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(OverlayNGSnappingTestOne.class);
    }

    public OverlayNGSnappingTestOne(String name) {
        super(name);
    }

    public void testRectanglesOneAjarUnion() {
        Geometry a = this.read("POLYGON ((10 10, 10 5, 5 5, 5 10, 10 10))");
        Geometry b = this.read("POLYGON ((10 15, 15 15, 15 7, 10.01 7, 10 15))");
        Geometry expected = this.read("POLYGON ((5 5, 5 10, 10 10, 10 15, 15 15, 15 7, 10.01 7, 10 5, 5 5))");
        this.checkEqual(expected, OverlayNGSnappingTestOne.union(a, b, 1.0));
    }

    public void testRectanglesBothAjarUnion() {
        Geometry a = this.read("POLYGON ((10.01 10, 10 5, 5 5, 5 10, 10.01 10))");
        Geometry b = this.read("POLYGON ((10 15, 15 15, 15 7, 10.01 7, 10 15))");
        Geometry expected = this.read("POLYGON ((5 5, 5 10, 10.01 10, 10 15, 15 15, 15 7, 10.01 7, 10 5, 5 5))");
        this.checkEqual(expected, OverlayNGSnappingTestOne.union(a, b, 1.0));
    }

    public void testRandomUnion() {
        Geometry a = this.read("POLYGON ((85.55954154387994 100, 92.87214039753759 100, 94.7254728121147 100, 98.69765702432045 96.38825885127041, 85.55954154387994 100))");
        Geometry b = this.read("POLYGON ((80.20688423699171 99.99999999999999, 100.00000000000003 99.99999999999997, 100.00000000000003 88.87471526860915, 80.20688423699171 99.99999999999999))");
        Geometry expected = this.read("POLYGON ((80.20688423699171 99.99999999999999, 85.55954154387994 100, 92.87214039753759 100, 94.7254728121147 100, 100.00000000000003 99.99999999999997, 100.00000000000003 88.87471526860915, 80.20688423699171 99.99999999999999))");
        this.checkEqual(expected, OverlayNGSnappingTestOne.union(a, b, 1.0E-8));
    }

    public void testTrianglesBSegmentsDisplacedSmallTolUnion() {
        Geometry a = this.read("POLYGON ((100 200, 200 0, 300 200, 100 200))");
        Geometry b = this.read("POLYGON ((150 200.01, 200 200.01, 260 200.01, 200 100, 150 200.01))");
        Geometry expected = this.read("POLYGON ((150 200.01, 200 200.01, 260 200.01, 300 200, 200 0, 100 200, 150 200.01))");
        this.checkEqual(expected, OverlayNGSnappingTestOne.union(a, b, 0.01));
    }

    public void testTrianglesBSegmentsDisplacedUnion() {
        Geometry a = this.read("POLYGON ((100 200, 200 0, 300 200, 100 200))");
        Geometry b = this.read("POLYGON ((150 200.01, 200 200.01, 260 200.01, 200 100, 150 200.01))");
        Geometry expected = this.read("POLYGON ((100 200, 150 200.01, 200 200.01, 260 200.01, 300 200, 200 0, 100 200))");
        this.checkEqual(expected, OverlayNGSnappingTestOne.union(a, b, 0.1));
    }

    public static Geometry union(Geometry a, Geometry b, double tolerance) {
        Noder noder = OverlayNGSnappingTestOne.getNoder(tolerance);
        return OverlayNG.overlay(a, b, 2, null, noder);
    }

    private static Noder getNoder(double tolerance) {
        SnappingNoder snapNoder = new SnappingNoder(tolerance);
        return new ValidatingNoder(snapNoder);
    }
}

