/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.io.ParseException;
import test.jts.GeometryTestCase;

public abstract class BaseDistanceTest
extends GeometryTestCase {
    private static final double TOLERANCE = 1.0E-10;

    public BaseDistanceTest(String name) {
        super(name);
    }

    public void testDisjointCollinearSegments() throws Exception {
        Geometry g1 = this.read("LINESTRING (0.0 0.0, 9.9 1.4)");
        Geometry g2 = this.read("LINESTRING (11.88 1.68, 21.78 3.08)");
        double dist = this.distance(g1, g2);
        BaseDistanceTest.assertEquals((double)1.9996999774966246, (double)dist, (double)1.0E-4);
        BaseDistanceTest.assertTrue((!this.isWithinDistance(g1, g2, 1.0) ? 1 : 0) != 0);
        BaseDistanceTest.assertTrue((boolean)this.isWithinDistance(g1, g2, 3.0));
    }

    public void testPolygonsDisjoint() {
        Geometry g1 = this.read("POLYGON ((40 320, 200 380, 320 80, 40 40, 40 320),  (180 280, 80 280, 100 100, 220 140, 180 280))");
        Geometry g2 = this.read("POLYGON ((160 240, 120 240, 120 160, 160 140, 160 240))");
        BaseDistanceTest.assertEquals((double)18.97366596, (double)this.distance(g1, g2), (double)1.0E-5);
        BaseDistanceTest.assertTrue((!this.isWithinDistance(g1, g2, 0.0) ? 1 : 0) != 0);
        BaseDistanceTest.assertTrue((!this.isWithinDistance(g1, g2, 10.0) ? 1 : 0) != 0);
        BaseDistanceTest.assertTrue((boolean)this.isWithinDistance(g1, g2, 20.0));
    }

    public void testPolygonsOverlapping() {
        Geometry g1 = this.read("POLYGON ((40 320, 200 380, 320 80, 40 40, 40 320),  (180 280, 80 280, 100 100, 220 140, 180 280))");
        Geometry g3 = this.read("POLYGON ((160 240, 120 240, 120 160, 180 100, 160 240))");
        BaseDistanceTest.assertEquals((double)0.0, (double)this.distance(g1, g3), (double)1.0E-9);
        BaseDistanceTest.assertTrue((boolean)this.isWithinDistance(g1, g3, 0.0));
    }

    public void testLinesIdentical() {
        LineString l1 = (LineString)this.read("LINESTRING(10 10, 20 20, 30 40)");
        BaseDistanceTest.assertEquals((double)0.0, (double)this.distance(l1, l1), (double)1.0E-5);
        BaseDistanceTest.assertTrue((boolean)this.isWithinDistance(l1, l1, 0.0));
    }

    public void testEmpty() {
        Geometry g1 = this.read("POINT (0 0)");
        Geometry g2 = this.read("POLYGON EMPTY");
        BaseDistanceTest.assertEquals((double)0.0, (double)g1.distance(g2), (double)0.0);
    }

    public void testClosestPoints1() throws Exception {
        this.checkDistanceNearestPoints("POLYGON ((200 180, 60 140, 60 260, 200 180))", "POINT (140 280)", 57.05597791103589, new Coordinate(111.6923076923077, 230.46153846153845), new Coordinate(140.0, 280.0));
    }

    public void testClosestPoints2() throws Exception {
        this.checkDistanceNearestPoints("POLYGON ((200 180, 60 140, 60 260, 200 180))", "MULTIPOINT ((140 280), (140 320))", 57.05597791103589, new Coordinate(111.6923076923077, 230.46153846153845), new Coordinate(140.0, 280.0));
    }

    public void testClosestPoints3() throws Exception {
        this.checkDistanceNearestPoints("LINESTRING (100 100, 200 100, 200 200, 100 200, 100 100)", "POINT (10 10)", 127.27922061357856, new Coordinate(100.0, 100.0), new Coordinate(10.0, 10.0));
    }

    public void testClosestPoints4() throws Exception {
        this.checkDistanceNearestPoints("LINESTRING (100 100, 200 200)", "LINESTRING (100 200, 200 100)", 0.0, new Coordinate(150.0, 150.0), new Coordinate(150.0, 150.0));
    }

    public void testClosestPoints5() throws Exception {
        this.checkDistanceNearestPoints("LINESTRING (100 100, 200 200)", "LINESTRING (150 121, 200 0)", 20.506096654409877, new Coordinate(135.5, 135.5), new Coordinate(150.0, 121.0));
    }

    public void testClosestPoints6() throws Exception {
        this.checkDistanceNearestPoints("POLYGON ((76 185, 125 283, 331 276, 324 122, 177 70, 184 155, 69 123, 76 185), (267 237, 148 248, 135 185, 223 189, 251 151, 286 183, 267 237))", "LINESTRING (153 204, 185 224, 209 207, 238 222, 254 186)", 13.788860460124573, new Coordinate(139.4956500724988, 206.78661188980183), new Coordinate(153.0, 204.0));
    }

    public void testClosestPoints7() throws Exception {
        this.checkDistanceNearestPoints("POLYGON ((76 185, 125 283, 331 276, 324 122, 177 70, 184 155, 69 123, 76 185), (267 237, 148 248, 135 185, 223 189, 251 151, 286 183, 267 237))", "LINESTRING (120 215, 185 224, 209 207, 238 222, 254 186)", 0.0, new Coordinate(120.0, 215.0), new Coordinate(120.0, 215.0));
    }

    private void checkDistanceNearestPoints(String wkt0, String wkt1, double distance, Coordinate p0, Coordinate p1) throws ParseException {
        Geometry g0 = this.read(wkt0);
        Geometry g1 = this.read(wkt1);
        Coordinate[] nearestPoints = this.nearestPoints(g0, g1);
        BaseDistanceTest.assertEquals((double)distance, (double)nearestPoints[0].distance(nearestPoints[1]), (double)1.0E-10);
        BaseDistanceTest.assertEquals((double)p0.x, (double)nearestPoints[0].x, (double)1.0E-10);
        BaseDistanceTest.assertEquals((double)p0.y, (double)nearestPoints[0].y, (double)1.0E-10);
        BaseDistanceTest.assertEquals((double)p1.x, (double)nearestPoints[1].x, (double)1.0E-10);
        BaseDistanceTest.assertEquals((double)p1.y, (double)nearestPoints[1].y, (double)1.0E-10);
    }

    protected abstract double distance(Geometry var1, Geometry var2);

    protected abstract boolean isWithinDistance(Geometry var1, Geometry var2, double var3);

    protected abstract Coordinate[] nearestPoints(Geometry var1, Geometry var2);
}

