/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.snapround.SnapRoundingNoder;

public class SegmentStringNodingTest
extends TestCase {
    WKTReader rdr = new WKTReader();

    public static void main(String[] args) {
        TestRunner.run(SegmentStringNodingTest.class);
    }

    public SegmentStringNodingTest(String name) {
        super(name);
    }

    public void testThinTriangle() throws Exception {
        String wkt = "LINESTRING ( 55121.54481117887 42694.49730855581, 55121.54481117887 42694.4973085558, 55121.458748617406 42694.419143944244, 55121.54481117887 42694.49730855581 )";
        PrecisionModel pm = new PrecisionModel(1.1131949079327356E11);
        this.checkNodedStrings(wkt, pm);
    }

    public void testSegmentLength1Failure() throws Exception {
        String wkt = "LINESTRING ( -1677607.6366504875 -588231.47100446, -1674050.1010869485 -587435.2186255794, -1670493.6527468169 -586636.7948791061, -1424286.3681743187 -525586.1397894835, -1670493.6527468169 -586636.7948791061, -1674050.1010869485 -587435.2186255795, -1677607.6366504875 -588231.47100446)";
        PrecisionModel pm = new PrecisionModel(1.11E10);
        this.checkNodedStrings(wkt, pm);
    }

    private void checkNodedStrings(String wkt, PrecisionModel pm) throws ParseException {
        Geometry g = new WKTReader().read(wkt);
        ArrayList<NodedSegmentString> strings = new ArrayList<NodedSegmentString>();
        strings.add(new NodedSegmentString(g.getCoordinates(), null));
        new SnapRoundingNoder(pm).computeNodes(strings);
        List noded = NodedSegmentString.getNodedSubstrings(strings);
        for (NodedSegmentString s : noded) {
            SegmentStringNodingTest.assertTrue((String)"Found a 1-point segmentstring", (s.size() >= 2 ? 1 : 0) != 0);
            SegmentStringNodingTest.assertTrue((String)"Found a collapsed edge", (!this.isCollapsed(s) ? 1 : 0) != 0);
        }
    }

    private boolean isCollapsed(SegmentString s) {
        if (s.size() != 3) {
            return false;
        }
        boolean isEndsEqual = s.getCoordinate(0).equals2D(s.getCoordinate(2));
        boolean isMiddleDifferent = !s.getCoordinate(0).equals2D(s.getCoordinate(1));
        boolean isCollapsed = isEndsEqual && isMiddleDifferent;
        return isCollapsed;
    }
}

