/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.util.GeometryFixer;
import test.jts.GeometryTestCase;

public class GeometryFixerTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(GeometryFixerTest.class);
    }

    public GeometryFixerTest(String name) {
        super(name);
    }

    public void testPoint() {
        this.checkFix("POINT (0 0)", "POINT (0 0)");
    }

    public void testPointNaN() {
        this.checkFix("POINT (0 Nan)", "POINT EMPTY");
    }

    public void testPointEmpty() {
        this.checkFix("POINT EMPTY", "POINT EMPTY");
    }

    public void testPointPosInf() {
        this.checkFix(this.createPoint(0.0, Double.POSITIVE_INFINITY), "POINT EMPTY");
    }

    public void testPointNegInf() {
        this.checkFix(this.createPoint(0.0, Double.POSITIVE_INFINITY), "POINT EMPTY");
    }

    private Point createPoint(double x, double y) {
        Coordinate p = new Coordinate(x, y);
        Point pt = this.getGeometryFactory().createPoint(p);
        return pt;
    }

    public void testMultiPointNaN() {
        this.checkFix("MULTIPOINT ((0 Nan))", "MULTIPOINT EMPTY");
    }

    public void testMultiPoint() {
        this.checkFix("MULTIPOINT ((0 0), (1 1))", "MULTIPOINT ((0 0), (1 1))");
    }

    public void testMultiPointWithEmpty() {
        this.checkFix("MULTIPOINT ((0 0), EMPTY)", "MULTIPOINT ((0 0))");
    }

    public void testMultiPointWithMultiEmpty() {
        this.checkFix("MULTIPOINT (EMPTY, EMPTY)", "MULTIPOINT EMPTY");
    }

    public void testLineStringEmpty() {
        this.checkFix("LINESTRING EMPTY", "LINESTRING EMPTY");
    }

    public void testLineStringCollapse() {
        this.checkFix("LINESTRING (0 0, 1 NaN, 0 0)", "LINESTRING EMPTY");
    }

    public void testLineStringCollapseMultipleRepeated() {
        this.checkFix("LINESTRING (0 0, 0 0, 0 0)", "LINESTRING EMPTY");
    }

    public void testLineStringKeepCollapse() {
        this.checkFixKeepCollapse("LINESTRING (0 0, 0 0, 0 0)", "POINT (0 0)");
    }

    public void testLineStringRepeated() {
        this.checkFix("LINESTRING (0 0, 0 0, 0 0, 0 0, 0 0, 1 1)", "LINESTRING (0 0, 1 1)");
    }

    public void testLineStringSelfCross() {
        this.checkFix("LINESTRING (0 0, 9 9, 9 5, 0 5)", "LINESTRING (0 0, 9 9, 9 5, 0 5)");
    }

    public void testLinearRingEmpty() {
        this.checkFix("LINEARRING EMPTY", "LINEARRING EMPTY");
    }

    public void testLinearRingCollapsePoint() {
        this.checkFix("LINEARRING (0 0, 1 NaN, 0 0)", "LINEARRING EMPTY");
    }

    public void testLinearRingCollapseLine() {
        this.checkFix("LINEARRING (0 0, 1 NaN, 1 0, 0 0)", "LINEARRING EMPTY");
    }

    public void testLinearRingKeepCollapsePoint() {
        this.checkFixKeepCollapse("LINEARRING (0 0, 1 NaN, 0 0)", "POINT (0 0)");
    }

    public void testLinearRingKeepCollapseLine() {
        this.checkFixKeepCollapse("LINEARRING (0 0, 1 NaN, 1 0, 0 0)", "LINESTRING (0 0, 1 0, 0 0)");
    }

    public void testLinearRingValid() {
        this.checkFix("LINEARRING (10 10, 10 90, 90 90, 90 10, 10 10)", "LINEARRING (10 10, 10 90, 90 90, 90 10, 10 10)");
    }

    public void testLinearRingFlat() {
        this.checkFix("LINEARRING (10 10, 10 90, 90 90, 10 90, 10 10)", "LINESTRING (10 10, 10 90, 90 90, 10 90, 10 10)");
    }

    public void testLinearRingSelfCross() {
        this.checkFix("LINEARRING (10 10, 10 90, 90 10, 90 90, 10 10)", "LINESTRING (10 10, 10 90, 90 10, 90 90, 10 10)");
    }

    public void testMultiLineStringSelfCross() {
        this.checkFix("MULTILINESTRING ((10 90, 90 10, 90 90), (90 50, 10 50))", "MULTILINESTRING ((10 90, 90 10, 90 90), (90 50, 10 50))");
    }

    public void testMultiLineStringWithCollapse() {
        this.checkFix("MULTILINESTRING ((10 10, 90 90), (10 10, 10 10, 10 10))", "LINESTRING (10 10, 90 90))");
    }

    public void testMultiLineStringKeepCollapse() {
        this.checkFixKeepCollapse("MULTILINESTRING ((10 10, 90 90), (10 10, 10 10, 10 10))", "GEOMETRYCOLLECTION (POINT (10 10), LINESTRING (10 10, 90 90))");
    }

    public void testMultiLineStringWithEmpty() {
        this.checkFix("MULTILINESTRING ((10 10, 90 90), EMPTY)", "LINESTRING (10 10, 90 90))");
    }

    public void testMultiLineStringWithMultiEmpty() {
        this.checkFix("MULTILINESTRING (EMPTY, EMPTY)", "MULTILINESTRING EMPTY");
    }

    public void testPolygonEmpty() {
        this.checkFix("POLYGON EMPTY", "POLYGON EMPTY");
    }

    public void testPolygonBowtie() {
        this.checkFix("POLYGON ((10 90, 90 10, 90 90, 10 10, 10 90))", "MULTIPOLYGON (((10 90, 50 50, 10 10, 10 90)), ((50 50, 90 90, 90 10, 50 50)))");
    }

    public void testPolygonHolesZeroAreaOverlapping() {
        this.checkFix("POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (80 70, 30 70, 30 20, 30 70, 80 70), (70 80, 70 30, 20 30, 70 30, 70 80))", "POLYGON ((90 90, 90 10, 10 10, 10 90, 90 90))");
    }

    public void testPolygonPosAndNegOverlap() {
        this.checkFix("POLYGON ((10 90, 50 90, 50 30, 70 30, 70 50, 30 50, 30 70, 90 70, 90 10, 10 10, 10 90))", "POLYGON ((10 90, 50 90, 50 70, 90 70, 90 10, 10 10, 10 90), (50 50, 50 30, 70 30, 70 50, 50 50))");
    }

    public void testHolesTouching() {
        this.checkFix("POLYGON ((0 0, 0 5, 6 5, 6 0, 0 0), (3 1, 4 1, 4 2, 3 2, 3 1), (3 2, 1 4, 5 4, 4 2, 4 3, 3 2, 2 3, 3 2))", "MULTIPOLYGON (((0 0, 0 5, 6 5, 6 0, 0 0), (1 4, 2 3, 3 2, 3 1, 4 1, 4 2, 5 4, 1 4)), ((3 2, 4 3, 4 2, 3 2)))");
    }

    public void testPolygonNaN() {
        this.checkFix("POLYGON ((10 90, 90 NaN, 90 10, 10 10, 10 90))", "POLYGON ((10 10, 10 90, 90 10, 10 10))");
    }

    public void testPolygonRepeated() {
        this.checkFix("POLYGON ((10 90, 90 10, 90 10, 90 10, 90 10, 90 10, 10 10, 10 90))", "POLYGON ((10 10, 10 90, 90 10, 10 10))");
    }

    public void testPolygonShellCollapse() {
        this.checkFix("POLYGON ((10 10, 10 90, 90 90, 10 90, 10 10), (20 80, 60 80, 60 40, 20 40, 20 80))", "POLYGON EMPTY");
    }

    public void testPolygonShellCollapseNaN() {
        this.checkFix("POLYGON ((10 10, 10 NaN, 90 NaN, 10 NaN, 10 10))", "POLYGON EMPTY");
    }

    public void testPolygonShellKeepCollapseNaN() {
        this.checkFixKeepCollapse("POLYGON ((10 10, 10 NaN, 90 NaN, 10 NaN, 10 10))", "POINT (10 10)");
    }

    public void testPolygonShellKeepCollapse() {
        this.checkFixKeepCollapse("POLYGON ((10 10, 10 90, 90 90, 10 90, 10 10), (20 80, 60 80, 60 40, 20 40, 20 80))", "LINESTRING (10 10, 10 90, 90 90, 10 90, 10 10)");
    }

    public void testPolygonHoleCollapse() {
        this.checkFix("POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (80 80, 20 80, 20 20, 20 80, 80 80))", "POLYGON ((10 10, 10 90, 90 90, 90 10, 10 10))");
    }

    public void testPolygonHoleKeepCollapse() {
        this.checkFixKeepCollapse("POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (80 80, 20 80, 20 20, 20 80, 80 80))", "POLYGON ((10 10, 10 90, 90 90, 90 10, 10 10))");
    }

    public void testMultiPolygonEmpty() {
        this.checkFix("MULTIPOLYGON EMPTY", "MULTIPOLYGON EMPTY");
    }

    public void testMultiPolygonMultiEmpty() {
        this.checkFix("MULTIPOLYGON (EMPTY, EMPTY)", "MULTIPOLYGON EMPTY");
    }

    public void testMultiPolygonWithEmpty() {
        this.checkFix("MULTIPOLYGON (((10 40, 40 40, 40 10, 10 10, 10 40)), EMPTY, ((50 40, 80 40, 80 10, 50 10, 50 40)))", "MULTIPOLYGON (((10 40, 40 40, 40 10, 10 10, 10 40)), ((50 40, 80 40, 80 10, 50 10, 50 40)))");
    }

    public void testMultiPolygonWithCollapse() {
        this.checkFix("MULTIPOLYGON (((10 40, 40 40, 40 10, 10 10, 10 40)), ((50 40, 50 40, 50 40, 50 40, 50 40)))", "POLYGON ((10 10, 10 40, 40 40, 40 10, 10 10))");
    }

    public void testMultiPolygonKeepCollapse() {
        this.checkFixKeepCollapse("MULTIPOLYGON (((10 40, 40 40, 40 10, 10 10, 10 40)), ((50 40, 50 40, 50 40, 50 40, 50 40)))", "GEOMETRYCOLLECTION (POINT (50 40), POLYGON ((10 10, 10 40, 40 40, 40 10, 10 10)))");
    }

    public void testGCEmpty() {
        this.checkFix("GEOMETRYCOLLECTION EMPTY", "GEOMETRYCOLLECTION EMPTY");
    }

    public void testGCWithAllEmpty() {
        this.checkFix("GEOMETRYCOLLECTION (POINT EMPTY, LINESTRING EMPTY, POLYGON EMPTY)", "GEOMETRYCOLLECTION (POINT EMPTY, LINESTRING EMPTY, POLYGON EMPTY)");
    }

    public void testPolygonZBowtie() {
        this.checkFixZ("POLYGON Z ((10 90 1, 90 10 9, 90 90 9, 10 10 1, 10 90 1))", "MULTIPOLYGON Z(((10 10 1, 10 90 1, 50 50 5, 10 10 1)), ((50 50 5, 90 90 9, 90 10 9, 50 50 5)))");
    }

    public void testPolygonZHoleOverlap() {
        this.checkFixZ("POLYGON Z ((10 90 1, 60 90 6, 60 10 6, 10 10 1, 10 90 1), (20 80 2, 90 80 9, 90 20 9, 20 20 2, 20 80 2))", "POLYGON Z((10 10 1, 10 90 1, 60 90 6, 60 80 6, 20 80 2, 20 20 2, 60 20 6, 60 10 6, 10 10 1))");
    }

    public void testMultiLineStringZKeepCollapse() {
        this.checkFixZKeepCollapse("MULTILINESTRING Z ((10 10 1, 90 90 9), (10 10 1, 10 10 2, 10 10 3))", "GEOMETRYCOLLECTION Z (POINT (10 10 1), LINESTRING (10 10 1, 90 90 9))");
    }

    private void checkFix(String wkt, String wktExpected) {
        Geometry geom = this.read(wkt);
        this.checkFix(geom, false, wktExpected);
    }

    private void checkFixKeepCollapse(String wkt, String wktExpected) {
        Geometry geom = this.read(wkt);
        this.checkFix(geom, true, wktExpected);
    }

    private void checkFix(Geometry input, String wktExpected) {
        this.checkFix(input, false, wktExpected);
    }

    private void checkFixKeepCollapse(Geometry input, String wktExpected) {
        this.checkFix(input, true, wktExpected);
    }

    private void checkFix(Geometry input, boolean keepCollapse, String wktExpected) {
        Geometry actual;
        if (keepCollapse) {
            GeometryFixer fixer = new GeometryFixer(input);
            fixer.setKeepCollapsed(true);
            actual = fixer.getResult();
        } else {
            actual = GeometryFixer.fix(input);
        }
        GeometryFixerTest.assertTrue((String)"Result is invalid", (boolean)actual.isValid());
        GeometryFixerTest.assertTrue((String)"Input geometry was not copied", (input != actual ? 1 : 0) != 0);
        GeometryFixerTest.assertTrue((String)"Result has aliased coordinates", (boolean)this.checkDeepCopy(input, actual));
        Geometry expected = this.read(wktExpected);
        this.checkEqual(expected, actual);
    }

    private boolean checkDeepCopy(Geometry geom1, Geometry geom2) {
        Coordinate[] pts2;
        Coordinate[] pts1 = geom1.getCoordinates();
        for (Coordinate p2 : pts2 = geom2.getCoordinates()) {
            if (!this.isIn(p2, pts1)) continue;
            return false;
        }
        return true;
    }

    private boolean isIn(Coordinate p, Coordinate[] pts) {
        for (int i = 0; i < pts.length; ++i) {
            if (p != pts[i]) continue;
            return true;
        }
        return false;
    }

    private void checkFixZ(String wkt, String wktExpected) {
        Geometry geom = this.read(wkt);
        this.checkFixZ(geom, false, wktExpected);
    }

    private void checkFixZKeepCollapse(String wkt, String wktExpected) {
        Geometry geom = this.read(wkt);
        this.checkFixZ(geom, true, wktExpected);
    }

    private void checkFixZ(Geometry input, boolean keepCollapse, String wktExpected) {
        Geometry actual;
        if (keepCollapse) {
            GeometryFixer fixer = new GeometryFixer(input);
            fixer.setKeepCollapsed(true);
            actual = fixer.getResult();
        } else {
            actual = GeometryFixer.fix(input);
        }
        GeometryFixerTest.assertTrue((String)"Result is invalid", (boolean)actual.isValid());
        Geometry expected = this.read(wktExpected);
        this.checkEqualXYZ(expected, actual);
    }
}

