/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.generator;

import java.util.ArrayList;
import org.locationtech.jts.generator.GeometryGenerator;
import org.locationtech.jts.generator.GridGenerator;
import org.locationtech.jts.generator.LineStringGenerator;
import org.locationtech.jts.generator.PointGenerator;
import org.locationtech.jts.generator.PolygonGenerator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class MultiGenerator
extends GeometryGenerator {
    private GeometryGenerator generator = null;
    private int numberGeometries = 2;
    private int generationAlgorithm = 0;
    public static final int BOX = 0;
    public static final int VERT = 1;
    public static final int HORZ = 2;

    public MultiGenerator(GeometryGenerator generator) {
        this.generator = generator;
    }

    @Override
    public Geometry create() {
        if (this.generator == null) {
            throw new NullPointerException("Missing child generator");
        }
        if (this.numberGeometries < 1) {
            throw new IllegalStateException("Too few child geoms to create");
        }
        ArrayList<Geometry> geoms = new ArrayList<Geometry>(this.numberGeometries);
        GridGenerator grid = GeometryGenerator.createGridGenerator();
        grid.setBoundingBox(this.boundingBox);
        grid.setGeometryFactory(this.geometryFactory);
        switch (this.generationAlgorithm) {
            case 0: {
                int nrow = (int)Math.sqrt(this.numberGeometries);
                int ncol = this.numberGeometries / nrow;
                grid.setNumberRows(nrow);
                grid.setNumberColumns(ncol);
                break;
            }
            case 1: {
                grid.setNumberRows(1);
                grid.setNumberColumns(this.numberGeometries);
                break;
            }
            case 2: {
                grid.setNumberRows(this.numberGeometries);
                grid.setNumberColumns(1);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid Alg. Specified");
            }
        }
        while (grid.canCreate()) {
            this.generator.setBoundingBox(grid.createEnv());
            geoms.add(this.generator.create());
        }
        if (this.generator instanceof PointGenerator) {
            return this.geometryFactory.createMultiPoint(geoms.toArray(new Point[this.numberGeometries]));
        }
        if (this.generator instanceof LineStringGenerator) {
            return this.geometryFactory.createMultiLineString(geoms.toArray(new LineString[this.numberGeometries]));
        }
        if (this.generator instanceof PolygonGenerator) {
            return this.geometryFactory.createMultiPolygon(geoms.toArray(new Polygon[this.numberGeometries]));
        }
        return this.geometryFactory.createGeometryCollection(geoms.toArray(new Geometry[this.numberGeometries]));
    }

    public int getNumberGeometries() {
        return this.numberGeometries;
    }

    public void setNumberGeometries(int numberGeometries) {
        this.numberGeometries = numberGeometries;
    }

    public GeometryGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public void setBoundingBox(Envelope boundingBox) {
        super.setBoundingBox(boundingBox);
        if (this.generator != null) {
            this.generator.setBoundingBox(boundingBox);
        }
    }

    @Override
    public void setDimensions(int dimensions) {
        super.setDimensions(dimensions);
        if (this.generator != null) {
            this.generator.setDimensions(dimensions);
        }
    }

    @Override
    public void setGeometryFactory(GeometryFactory geometryFactory) {
        super.setGeometryFactory(geometryFactory);
        if (this.generator != null) {
            this.generator.setGeometryFactory(geometryFactory);
        }
    }
}

