/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.awt;

import java.awt.Shape;
import junit.textui.TestRunner;
import org.locationtech.jts.awt.ShapeReader;
import org.locationtech.jts.awt.ShapeWriter;
import org.locationtech.jts.geom.Geometry;
import test.jts.GeometryTestCase;

public class PolygonShapeTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(PolygonShapeTest.class);
    }

    public PolygonShapeTest(String name) {
        super(name);
    }

    public void testFlatness() {
        Geometry geom = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        ShapeWriter sw = new ShapeWriter();
        Shape shp = sw.toShape(geom);
        Geometry geom2 = ShapeReader.read(shp, 0.5, geom.getFactory());
        Geometry geomExpected = this.read("POLYGON ((100 -200, 200 -200, 200 -100, 100 -100, 100 -200))");
        PolygonShapeTest.assertTrue((boolean)geomExpected.equalsExact(geom2));
    }

    public void testEmptyHole() {
        Geometry geom = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200), EMPTY)");
        ShapeWriter sw = new ShapeWriter();
        Shape shp = sw.toShape(geom);
        Geometry geom2 = ShapeReader.read(shp, 0.5, geom.getFactory());
        Geometry geomExpected = this.read("POLYGON ((100 -200, 200 -200, 200 -100, 100 -100, 100 -200))");
        PolygonShapeTest.assertTrue((boolean)geomExpected.equalsExact(geom2));
    }
}

