/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.CGAlgorithmsDD;
import org.locationtech.jts.algorithm.NonRobustCGAlgorithms;
import org.locationtech.jts.algorithm.OrientationIndexTest;
import org.locationtech.jts.algorithm.RobustDeterminant;
import org.locationtech.jts.algorithm.ShewchuksDeterminant;
import org.locationtech.jts.geom.Coordinate;

public class OrientationIndexFailureTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(OrientationIndexFailureTest.class);
    }

    public OrientationIndexFailureTest(String name) {
        super(name);
    }

    public void testSanity() throws Exception {
        OrientationIndexFailureTest.assertTrue((boolean)OrientationIndexTest.isAllOrientationsEqual(OrientationIndexTest.getCoordinates("LINESTRING ( 0 0, 0 1, 1 1)")));
    }

    public void testBadCCW() throws Exception {
        Coordinate[] pts = new Coordinate[]{new Coordinate(1.4540766091864998, -7.989685402102996), new Coordinate(23.131039116367354, -7.004368924503866), new Coordinate(1.4540766091865, -7.989685402102996)};
        this.checkOrientation(pts);
    }

    public void testBadCCW2() throws Exception {
        Coordinate[] pts = new Coordinate[]{new Coordinate(219.3649559090992, 140.84159161824724), new Coordinate(168.9018919682399, -5.713787599646864), new Coordinate(186.80814046338352, 46.28973405831556)};
        this.checkOrientation(pts);
    }

    public void testBadCCW3() throws Exception {
        Coordinate[] pts = new Coordinate[]{new Coordinate(279.56857838488514, -186.3790522565901), new Coordinate(-20.43142161511487, 13.620947743409914), new Coordinate(0.0, 0.0)};
        this.checkOrientation(pts);
    }

    public void testBadCCW4() throws Exception {
        Coordinate[] pts = new Coordinate[]{new Coordinate(-26.2, 188.7), new Coordinate(37.0, 290.7), new Coordinate(21.2, 265.2)};
        this.checkOrientation(pts);
    }

    public void testBadCCW5() throws Exception {
        Coordinate[] pts = new Coordinate[]{new Coordinate(-5.9, 163.1), new Coordinate(76.1, 250.7), new Coordinate(14.6, 185.0)};
        this.checkOrientation(pts);
    }

    public void testBadCCW7() throws Exception {
        Coordinate[] pts = new Coordinate[]{new Coordinate(-0.9575, 0.4511), new Coordinate(-0.9295, 0.3291), new Coordinate(-0.8945, 0.1766)};
        this.checkDD(pts, true);
        this.checkShewchuk(pts, false);
        this.checkOriginalJTS(pts, false);
    }

    public void testBadCCW7_2() throws Exception {
        Coordinate[] pts = new Coordinate[]{new Coordinate(-9575.0, 4511.0), new Coordinate(-9295.0, 3291.0), new Coordinate(-8945.0, 1766.0)};
        this.checkDD(pts, true);
        this.checkShewchuk(pts, true);
        this.checkOriginalJTS(pts, true);
    }

    public void testBadCCW6() throws Exception {
        Coordinate[] pts = new Coordinate[]{new Coordinate(-140.8859438214298, 140.88594382142983), new Coordinate(-57.309236848216706, 57.30923684821671), new Coordinate(-190.9188309203678, 190.91883092036784)};
        this.checkOrientation(pts);
    }

    public void testSimpleFail() {
        Coordinate p1 = new Coordinate(1.0, 1.0);
        Coordinate p2 = new Coordinate(3.0, 3.5);
        Coordinate q = new Coordinate(2.6, 3.0);
        int indexDD = CGAlgorithmsDD.orientationIndex(p1, p2, q);
        int index = NonRobustCGAlgorithms.orientationIndex(p1, p2, q);
        OrientationIndexFailureTest.assertTrue((String)"orientationIndex DD is not expected to be correct", (indexDD != 0 ? 1 : 0) != 0);
        OrientationIndexFailureTest.assertTrue((String)"orientationIndex in DP is not expected to be correct", (index != 0 ? 1 : 0) != 0);
    }

    void checkOrientation(Coordinate[] pts) {
        this.checkDD(pts, true);
        this.checkShewchuk(pts, true);
        this.checkOriginalJTS(pts, false);
    }

    private void checkShewchuk(Coordinate[] pts, boolean expected) {
        OrientationIndexFailureTest.assertTrue((String)"Shewchuk", (expected == OrientationIndexFailureTest.isAllOrientationsEqualSD(pts) ? 1 : 0) != 0);
    }

    private void checkOriginalJTS(Coordinate[] pts, boolean expected) {
        OrientationIndexFailureTest.assertTrue((String)"JTS RobustDeterminant FAIL", (expected == OrientationIndexFailureTest.isAllOrientationsEqualRD(pts) ? 1 : 0) != 0);
    }

    private void checkDD(Coordinate[] pts, boolean expected) {
        OrientationIndexFailureTest.assertTrue((String)"DD", (expected == OrientationIndexFailureTest.isAllOrientationsEqualDD(pts) ? 1 : 0) != 0);
    }

    public static boolean isAllOrientationsEqual(double p0x, double p0y, double p1x, double p1y, double p2x, double p2y) {
        Coordinate[] pts = new Coordinate[]{new Coordinate(p0x, p0y), new Coordinate(p1x, p1y), new Coordinate(p2x, p2y)};
        if (!OrientationIndexFailureTest.isAllOrientationsEqualDD(pts)) {
            throw new IllegalStateException("High-precision orientation computation FAILED");
        }
        return OrientationIndexTest.isAllOrientationsEqual(pts);
    }

    public static boolean isAllOrientationsEqualDD(Coordinate[] pts) {
        int orient0 = CGAlgorithmsDD.orientationIndex(pts[0], pts[1], pts[2]);
        int orient1 = CGAlgorithmsDD.orientationIndex(pts[1], pts[2], pts[0]);
        int orient2 = CGAlgorithmsDD.orientationIndex(pts[2], pts[0], pts[1]);
        return orient0 == orient1 && orient0 == orient2;
    }

    public static boolean isAllOrientationsEqualSD(Coordinate[] pts) {
        int orient0 = ShewchuksDeterminant.orientationIndex(pts[0], pts[1], pts[2]);
        int orient1 = ShewchuksDeterminant.orientationIndex(pts[1], pts[2], pts[0]);
        int orient2 = ShewchuksDeterminant.orientationIndex(pts[2], pts[0], pts[1]);
        return orient0 == orient1 && orient0 == orient2;
    }

    public static boolean isAllOrientationsEqualRD(Coordinate[] pts) {
        int[] orient = new int[]{RobustDeterminant.orientationIndex(pts[0], pts[1], pts[2]), RobustDeterminant.orientationIndex(pts[1], pts[2], pts[0]), RobustDeterminant.orientationIndex(pts[2], pts[0], pts[1])};
        return orient[0] == orient[1] && orient[0] == orient[2];
    }
}

