/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import java.util.Stack;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;

public class ConvexHullTest
extends TestCase {
    PrecisionModel precisionModel = new PrecisionModel(1000.0);
    GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);

    public static void main(String[] args) {
        TestRunner.run((Test)ConvexHullTest.suite());
    }

    public ConvexHullTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ConvexHullTest.class);
    }

    public void testManyIdenticalPoints() throws Exception {
        Coordinate[] pts = new Coordinate[100];
        for (int i = 0; i < 99; ++i) {
            pts[i] = new Coordinate(0.0, 0.0);
        }
        pts[99] = new Coordinate(1.0, 1.0);
        ConvexHull ch = new ConvexHull(pts, this.geometryFactory);
        Geometry actualGeometry = ch.getConvexHull();
        Geometry expectedGeometry = this.reader.read("LINESTRING (0 0, 1 1)");
        ConvexHullTest.assertTrue((boolean)expectedGeometry.equalsExact(actualGeometry));
    }

    public void testAllIdenticalPoints() throws Exception {
        Coordinate[] pts = new Coordinate[100];
        for (int i = 0; i < 100; ++i) {
            pts[i] = new Coordinate(0.0, 0.0);
        }
        ConvexHull ch = new ConvexHull(pts, this.geometryFactory);
        Geometry actualGeometry = ch.getConvexHull();
        Geometry expectedGeometry = this.reader.read("POINT (0 0)");
        ConvexHullTest.assertTrue((boolean)expectedGeometry.equalsExact(actualGeometry));
    }

    public void test1() throws Exception {
        WKTReader reader = new WKTReader(new GeometryFactory(new PrecisionModel(1.0), 0));
        LineString lineString = (LineString)reader.read("LINESTRING (30 220, 240 220, 240 220)");
        LineString convexHull = (LineString)reader.read("LINESTRING (30 220, 240 220)");
        ConvexHullTest.assertTrue((boolean)convexHull.equalsExact(lineString.convexHull()));
    }

    public void test2() throws Exception {
        WKTReader reader = new WKTReader(new GeometryFactory(new PrecisionModel(1.0), 0));
        Geometry geometry = reader.read("MULTIPOINT (130 240, 130 240, 130 240, 570 240, 570 240, 570 240, 650 240)");
        LineString convexHull = (LineString)reader.read("LINESTRING (130 240, 650 240)");
        ConvexHullTest.assertTrue((boolean)convexHull.equalsExact(geometry.convexHull()));
    }

    public void test3() throws Exception {
        WKTReader reader = new WKTReader(new GeometryFactory(new PrecisionModel(1.0), 0));
        Geometry geometry = reader.read("MULTIPOINT (0 0, 0 0, 10 0)");
        LineString convexHull = (LineString)reader.read("LINESTRING (0 0, 10 0)");
        ConvexHullTest.assertTrue((boolean)convexHull.equalsExact(geometry.convexHull()));
    }

    public void test4() throws Exception {
        WKTReader reader = new WKTReader(new GeometryFactory(new PrecisionModel(1.0), 0));
        Geometry geometry = reader.read("MULTIPOINT (0 0, 10 0, 10 0)");
        LineString convexHull = (LineString)reader.read("LINESTRING (0 0, 10 0)");
        ConvexHullTest.assertTrue((boolean)convexHull.equalsExact(geometry.convexHull()));
    }

    public void test5() throws Exception {
        WKTReader reader = new WKTReader(new GeometryFactory(new PrecisionModel(1.0), 0));
        Geometry geometry = reader.read("MULTIPOINT (0 0, 5 0, 10 0)");
        LineString convexHull = (LineString)reader.read("LINESTRING (0 0, 10 0)");
        ConvexHullTest.assertTrue((boolean)convexHull.equalsExact(geometry.convexHull()));
    }

    public void test6() throws Exception {
        WKTReader reader = new WKTReader(new GeometryFactory(new PrecisionModel(1.0), 0));
        Geometry actualGeometry = reader.read("MULTIPOINT (0 0, 5 1, 10 0)").convexHull();
        Geometry expectedGeometry = reader.read("POLYGON ((0 0, 5 1, 10 0, 0 0))");
        ConvexHullTest.assertEquals((String)expectedGeometry.toString(), (String)actualGeometry.toString());
    }

    public void testToArray() throws Exception {
        ConvexHullEx convexHull = new ConvexHullEx(this.geometryFactory.createGeometryCollection(null));
        Stack<Coordinate> stack = new Stack<Coordinate>();
        stack.push(new Coordinate(0.0, 0.0));
        stack.push(new Coordinate(1.0, 1.0));
        stack.push(new Coordinate(2.0, 2.0));
        Coordinate[] array1 = convexHull.toCoordinateArray(stack);
        ConvexHullTest.assertEquals((int)3, (int)array1.length);
        ConvexHullTest.assertEquals((Object)new Coordinate(0.0, 0.0), (Object)array1[0]);
        ConvexHullTest.assertEquals((Object)new Coordinate(1.0, 1.0), (Object)array1[1]);
        ConvexHullTest.assertEquals((Object)new Coordinate(2.0, 2.0), (Object)array1[2]);
        ConvexHullTest.assertTrue((!((Object)array1[0]).equals(array1[1]) ? 1 : 0) != 0);
    }

    public void test7() throws Exception {
        WKTReader reader = new WKTReader(new GeometryFactory(new PrecisionModel(1.0), 0));
        Geometry geometry = reader.read("MULTIPOINT (0 0, 0 0, 5 0, 5 0, 10 0, 10 0)");
        LineString convexHull = (LineString)reader.read("LINESTRING (0 0, 10 0)");
        ConvexHullTest.assertTrue((boolean)convexHull.equalsExact(geometry.convexHull()));
    }

    private static class ConvexHullEx
    extends ConvexHull {
        public ConvexHullEx(Geometry geometry) {
            super(geometry);
        }

        @Override
        protected Coordinate[] toCoordinateArray(Stack stack) {
            return super.toCoordinateArray(stack);
        }
    }
}

