/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.measurement;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.measurement.MeasurementMode;
import org.openstreetmap.josm.plugins.measurement.MeasurementPlugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MeasurementLayer
extends Layer {
    private static Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(MeasurementPlugin.class.getResource("/images/measurement.png")));
    private Collection<WayPoint> points = new ArrayList<WayPoint>(32);

    public MeasurementLayer(String name) {
        super(name);
    }

    public Icon getIcon() {
        return icon;
    }

    public String getToolTipText() {
        return I18n.tr((String)"Layer to make measurements", (Object[])new Object[0]);
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        g.setColor(Color.green);
        Point l = null;
        for (WayPoint p : this.points) {
            Point pnt = mv.getPoint(p.getCoor());
            if (l != null) {
                g.drawLine(l.x, l.y, pnt.x, pnt.y);
            }
            g.drawOval(pnt.x - 2, pnt.y - 2, 4, 4);
            l = pnt;
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new GPXLayerImportAction(this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public void removeLastPoint() {
        WayPoint l = null;
        Iterator<WayPoint> iterator = this.points.iterator();
        while (iterator.hasNext()) {
            WayPoint p;
            l = p = iterator.next();
        }
        if (l != null) {
            this.points.remove(l);
        }
        this.recalculate();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        LatLon coor = MainApplication.getMap().mapView.getLatLon(e.getX(), e.getY());
        this.points.add(new WayPoint(coor));
        this.recalculate();
    }

    public void reset() {
        this.points.clear();
        this.recalculate();
    }

    private void recalculate() {
        double pathLength = 0.0;
        double segLength = 0.0;
        WayPoint last = null;
        for (WayPoint p : this.points) {
            if (last != null) {
                segLength = MeasurementLayer.calcDistance(last, p);
                pathLength += segLength;
            }
            last = p;
        }
        if (MeasurementPlugin.measurementDialog != null) {
            MeasurementPlugin.measurementDialog.pathLengthLabel.setText(NavigatableComponent.getDistText((double)pathLength));
        }
        if (MainApplication.getMap().mapMode instanceof MeasurementMode) {
            MainApplication.getMap().statusLine.setDist(pathLength);
        }
        this.invalidate();
    }

    public static double calcX(LatLon p1) {
        return p1.lat() * Math.PI * 6367000.0 / 180.0;
    }

    public static double calcY(LatLon p1) {
        return p1.lon() * 111125.11347447896 * Math.cos(p1.lat() * Math.PI / 180.0);
    }

    public static double calcDistance(WayPoint p1, WayPoint p2) {
        return p1.getCoor().greatCircleDistance(p2.getCoor());
    }

    public static double angleBetween(WayPoint p1, WayPoint p2) {
        return MeasurementLayer.angleBetween((ILatLon)p1.getCoor(), (ILatLon)p2.getCoor());
    }

    public static double angleBetween(ILatLon p1, ILatLon p2) {
        double lat1 = p1.lat() * Math.PI / 180.0;
        double lon1 = p1.lon() * Math.PI / 180.0;
        double lat2 = p2.lat() * Math.PI / 180.0;
        double lon2 = p2.lon() * Math.PI / 180.0;
        double dlon = lon2 - lon1;
        double coslat2 = Math.cos(lat2);
        return 180.0 * Math.atan2(coslat2 * Math.sin(dlon), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * coslat2 * Math.cos(dlon)) / Math.PI;
    }

    public static double oldAngleBetween(LatLon p1, LatLon p2) {
        double lat1 = p1.lat() * Math.PI / 180.0;
        double lon1 = p1.lon() * Math.PI / 180.0;
        double lat2 = p2.lat() * Math.PI / 180.0;
        double lon2 = p2.lon() * Math.PI / 180.0;
        double dlon = lon2 - lon1;
        double dlat = lat2 - lat1;
        double a = Math.pow(Math.sin(dlat / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(dlon / 2.0), 2.0);
        double d = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double heading = Math.acos((Math.sin(lat2) - Math.sin(lat1) * Math.cos(d)) / (Math.sin(d) * Math.cos(lat1)));
        if (Math.sin(lon2 - lon1) < 0.0) {
            heading = Math.PI * 2 - heading;
        }
        return heading * 180.0 / Math.PI;
    }

    private class GPXLayerImportAction
    extends AbstractAction {
        private DefaultListModel<GpxLayer> model;

        public GPXLayerImportAction(MeasurementLayer layer) {
            super(I18n.tr((String)"Import path from GPX layer", (Object[])new Object[0]), ImageProvider.get((String)"dialogs", (String)"edit"));
            this.model = new DefaultListModel();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Box panel = Box.createVerticalBox();
            final JList<GpxLayer> layerList = new JList<GpxLayer>(this.model);
            List data = MainApplication.getLayerManager().getLayers();
            Layer lastLayer = null;
            int layerCnt = 0;
            for (Layer l : data) {
                if (!(l instanceof GpxLayer)) continue;
                this.model.addElement((GpxLayer)l);
                lastLayer = l;
                ++layerCnt;
            }
            if (layerCnt == 1) {
                layerList.setSelectedValue(lastLayer, true);
            }
            if (layerCnt > 0) {
                layerList.setCellRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        Layer layer = (Layer)value;
                        JLabel label = (JLabel)super.getListCellRendererComponent(list, layer.getName(), index, isSelected, cellHasFocus);
                        Icon icon = layer.getIcon();
                        label.setIcon(icon);
                        label.setToolTipText(layer.getToolTipText());
                        return label;
                    }
                });
                JCheckBox dropFirst = new JCheckBox(I18n.tr((String)"Drop existing path", (Object[])new Object[0]));
                panel.add(layerList);
                panel.add(dropFirst);
                JOptionPane optionPane = new JOptionPane(panel, 3, 2){

                    @Override
                    public void selectInitialValue() {
                        layerList.requestFocusInWindow();
                    }
                };
                JDialog dlg = optionPane.createDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Import path from GPX layer", (Object[])new Object[0]));
                dlg.setVisible(true);
                Object answer = optionPane.getValue();
                if (answer == null || answer == JOptionPane.UNINITIALIZED_VALUE || answer instanceof Integer && (Integer)answer != 0) {
                    return;
                }
                GpxLayer gpx = layerList.getSelectedValue();
                if (dropFirst.isSelected()) {
                    MeasurementLayer.this.points = new ArrayList(32);
                }
                for (IGpxTrack trk : gpx.data.tracks) {
                    for (IGpxTrackSegment trkseg : trk.getSegments()) {
                        for (WayPoint p : trkseg.getWayPoints()) {
                            MeasurementLayer.this.points.add(p);
                        }
                    }
                }
                MeasurementLayer.this.recalculate();
            } else {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"No GPX data layer found.", (Object[])new Object[0]));
            }
        }
    }
}

