/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.h2.store.fs.FileObject;
import org.h2.util.IOUtils;

public class FileObjectZip
implements FileObject {
    private static final byte[] SKIP_BUFFER = new byte[1024];
    private ZipFile file;
    private ZipEntry entry;
    private long pos;
    private InputStream in;
    private long inPos;
    private long length;
    private boolean skipUsingRead;

    FileObjectZip(ZipFile zipFile, ZipEntry zipEntry) {
        this.file = zipFile;
        this.entry = zipEntry;
        this.length = zipEntry.getSize();
    }

    public void close() {
    }

    public long getFilePointer() {
        return this.pos;
    }

    public long length() {
        return this.length;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.inPos > this.pos) {
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
        }
        if (this.in == null) {
            this.in = this.file.getInputStream(this.entry);
            this.inPos = 0L;
        }
        if (this.inPos < this.pos) {
            long l = this.pos - this.inPos;
            if (!this.skipUsingRead) {
                try {
                    IOUtils.skipFully(this.in, l);
                }
                catch (NullPointerException nullPointerException) {
                    this.skipUsingRead = true;
                }
            }
            if (this.skipUsingRead) {
                while (l > 0L) {
                    int n4 = (int)Math.min((long)SKIP_BUFFER.length, l);
                    n4 = this.in.read(SKIP_BUFFER, 0, n4);
                    l -= (long)n4;
                }
            }
            this.inPos = this.pos;
        }
        if ((n3 = IOUtils.readFully(this.in, byArray, n, n2)) != n2) {
            throw new EOFException();
        }
        this.pos += (long)n2;
        this.inPos += (long)n2;
    }

    public void seek(long l) {
        this.pos = l;
    }

    public void setFileLength(long l) throws IOException {
        throw new IOException("File is read-only");
    }

    public void sync() {
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        throw new IOException("File is read-only");
    }

    public String getName() {
        return this.file.getName();
    }
}

