/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.math.XMath;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.TransformException;
import si.uom.NonSI;
import si.uom.SI;
import tech.units.indriya.AbstractUnit;

public abstract class MapProjection
extends AbstractMathTransform
implements MathTransform2D,
Serializable {
    public static boolean SKIP_SANITY_CHECKS = false;
    private static final long serialVersionUID = -406751619777246914L;
    protected static final Logger LOGGER = Logging.getLogger(MapProjection.class);
    private static final double EPSILON = 1.0E-6;
    private static final double ANGLE_TOLERANCE = 1.0E-4;
    private static final double ITERATION_TOLERANCE = 1.0E-10;
    private static final double MLFN_TOL = 1.0E-11;
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double C00 = 1.0;
    private static final double C02 = 0.25;
    private static final double C04 = 0.046875;
    private static final double C06 = 0.01953125;
    private static final double C08 = 0.01068115234375;
    private static final double C22 = 0.75;
    private static final double C44 = 0.46875;
    private static final double C46 = 0.013020833333333334;
    private static final double C48 = 0.007120768229166667;
    private static final double C66 = 0.3645833333333333;
    private static final double C68 = 0.005696614583333333;
    private static final double C88 = 0.3076171875;
    protected final double excentricity;
    protected final double excentricitySquared;
    protected final boolean isSpherical;
    protected final double semiMajor;
    protected final double semiMinor;
    protected double centralMeridian;
    protected double latitudeOfOrigin;
    protected double scaleFactor;
    protected final double falseEasting;
    protected final double falseNorthing;
    protected double globalScale;
    private transient MathTransform2D inverse;
    protected double en0;
    protected double en1;
    protected double en2;
    protected double en3;
    protected double en4;
    private transient int rangeCheckSemaphore;
    private static int globalRangeCheckSemaphore = 1;
    protected boolean invertible = true;

    protected MapProjection(ParameterValueGroup values) throws ParameterNotFoundException {
        this(values, null);
    }

    MapProjection(ParameterValueGroup values, Collection<GeneralParameterDescriptor> expected) throws ParameterNotFoundException {
        if (expected == null) {
            expected = this.getParameterDescriptors().descriptors();
        }
        this.semiMajor = this.doubleValue(expected, AbstractProvider.SEMI_MAJOR, values);
        this.semiMinor = this.doubleValue(expected, AbstractProvider.SEMI_MINOR, values);
        this.centralMeridian = this.doubleValue(expected, AbstractProvider.CENTRAL_MERIDIAN, values);
        this.latitudeOfOrigin = this.doubleValue(expected, AbstractProvider.LATITUDE_OF_ORIGIN, values);
        this.scaleFactor = this.doubleValue(expected, AbstractProvider.SCALE_FACTOR, values);
        this.falseEasting = this.doubleValue(expected, AbstractProvider.FALSE_EASTING, values);
        this.falseNorthing = this.doubleValue(expected, AbstractProvider.FALSE_NORTHING, values);
        this.isSpherical = this.semiMajor == this.semiMinor;
        this.excentricitySquared = 1.0 - this.semiMinor * this.semiMinor / (this.semiMajor * this.semiMajor);
        this.excentricity = Math.sqrt(this.excentricitySquared);
        this.globalScale = this.scaleFactor * this.semiMajor;
        MapProjection.ensureLongitudeInRange(AbstractProvider.CENTRAL_MERIDIAN, this.centralMeridian, true);
        MapProjection.ensureLatitudeInRange(AbstractProvider.LATITUDE_OF_ORIGIN, this.latitudeOfOrigin, true);
        this.en0 = 1.0 - this.excentricitySquared * (0.25 + this.excentricitySquared * (0.046875 + this.excentricitySquared * (0.01953125 + this.excentricitySquared * 0.01068115234375)));
        this.en1 = this.excentricitySquared * (0.75 - this.excentricitySquared * (0.046875 + this.excentricitySquared * (0.01953125 + this.excentricitySquared * 0.01068115234375)));
        double t = this.excentricitySquared * this.excentricitySquared;
        this.en2 = t * (0.46875 - this.excentricitySquared * (0.013020833333333334 + this.excentricitySquared * 0.007120768229166667));
        this.en3 = (t *= this.excentricitySquared) * (0.3645833333333333 - this.excentricitySquared * 0.005696614583333333);
        this.en4 = t * this.excentricitySquared * 0.3076171875;
    }

    boolean isExpectedParameter(Collection<GeneralParameterDescriptor> expected, ParameterDescriptor param) {
        return expected.contains(param);
    }

    final double doubleValue(Collection<GeneralParameterDescriptor> expected, ParameterDescriptor param, ParameterValueGroup group) throws ParameterNotFoundException {
        double v;
        if (this.isExpectedParameter(expected, param)) {
            return AbstractProvider.doubleValue(param, group);
        }
        Object value = param.getDefaultValue();
        if (value instanceof Number) {
            v = ((Number)value).doubleValue();
            if (NonSI.DEGREE_ANGLE.equals(param.getUnit())) {
                v = Math.toRadians(v);
            }
        } else {
            v = Double.NaN;
        }
        return v;
    }

    final void ensureSpherical() throws IllegalArgumentException {
        if (!this.isSpherical) {
            throw new IllegalArgumentException(Errors.format(45));
        }
    }

    static void ensureLatitudeEquals(ParameterDescriptor name, double y, double expected) throws IllegalArgumentException {
        if (!(Math.abs(Math.abs(y) - expected) < 1.0E-6)) {
            y = Math.toDegrees(y);
            String n = name.getName().getCode();
            throw new InvalidParameterValueException(Errors.format(58, n, new Latitude(y)), n, y);
        }
    }

    static void ensureLatitudeInRange(ParameterDescriptor name, double y, boolean edge) throws IllegalArgumentException {
        if (edge ? y >= -1.5707963267948966 && y <= 1.5707963267948966 : y > -1.5707963267948966 && y < 1.5707963267948966) {
            return;
        }
        y = Math.toDegrees(y);
        throw new InvalidParameterValueException(Errors.format(85, new Latitude(y)), name.getName().getCode(), y);
    }

    static void ensureLongitudeInRange(ParameterDescriptor name, double x, boolean edge) throws IllegalArgumentException {
        if (edge ? x >= -Math.PI && x <= Math.PI : x > -Math.PI && x < Math.PI) {
            return;
        }
        x = Math.toDegrees(x);
        throw new InvalidParameterValueException(Errors.format(88, new Longitude(x)), name.getName().getCode(), x);
    }

    private static boolean verifyGeographicRanges(AbstractMathTransform tr, double x, double y) {
        boolean yOut;
        boolean xOut = x < -180.0001 || x > 180.0001;
        boolean bl = yOut = y < -90.0001 || y > 90.0001;
        if (!xOut && !yOut) {
            return false;
        }
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuilder buffer = new StringBuilder();
        buffer.append(Errors.format(153, tr.getName()));
        if (xOut) {
            buffer.append(lineSeparator);
            buffer.append(Errors.format(88, new Longitude(x)));
        }
        if (yOut) {
            buffer.append(lineSeparator);
            buffer.append(Errors.format(85, new Latitude(y)));
        }
        LogRecord record = new LogRecord(Level.WARNING, buffer.toString());
        String classe = tr instanceof Inverse ? ((Inverse)tr).inverse().getClass().getName() + ".Inverse" : tr.getClass().getName();
        record.setSourceClassName(classe);
        record.setSourceMethodName("transform");
        record.setLoggerName(LOGGER.getName());
        LOGGER.log(record);
        return true;
    }

    final void set(Collection<GeneralParameterDescriptor> expected, ParameterDescriptor<?> param, ParameterValueGroup group, double value) {
        if (this.isExpectedParameter(expected, param)) {
            if (NonSI.DEGREE_ANGLE.equals(param.getUnit())) {
                double test;
                double old = value = Math.toDegrees(value);
                if ((value = XMath.trimDecimalFractionDigits(value, 4, 12)) == old && (test = XMath.trimDecimalFractionDigits(old *= 3.0, 4, 12)) != old) {
                    value = test / 3.0;
                }
            }
            group.parameter(param.getName().getCode()).setValue(value);
        }
    }

    @Override
    public abstract ParameterDescriptorGroup getParameterDescriptors();

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterDescriptorGroup descriptor = this.getParameterDescriptors();
        List<GeneralParameterDescriptor> expected = descriptor.descriptors();
        ParameterValueGroup values = descriptor.createValue();
        this.set(expected, AbstractProvider.SEMI_MAJOR, values, this.semiMajor);
        this.set(expected, AbstractProvider.SEMI_MINOR, values, this.semiMinor);
        this.set(expected, AbstractProvider.CENTRAL_MERIDIAN, values, this.centralMeridian);
        this.set(expected, AbstractProvider.LATITUDE_OF_ORIGIN, values, this.latitudeOfOrigin);
        this.set(expected, AbstractProvider.SCALE_FACTOR, values, this.scaleFactor);
        this.set(expected, AbstractProvider.FALSE_EASTING, values, this.falseEasting);
        this.set(expected, AbstractProvider.FALSE_NORTHING, values, this.falseNorthing);
        return values;
    }

    @Override
    public final int getSourceDimensions() {
        return 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 2;
    }

    protected double orthodromicDistance(Point2D source, Point2D target) {
        if (source.distanceSq(target) > 1.0) {
            double y1 = Math.toRadians(source.getY());
            double y2 = Math.toRadians(target.getY());
            double dx = Math.toRadians(Math.abs(target.getX() - source.getX()) % 360.0);
            double rho = Math.sin(y1) * Math.sin(y2) + Math.cos(y1) * Math.cos(y2) * Math.cos(dx);
            if (rho > 1.0) {
                assert (rho <= 1.000001) : rho;
                rho = 1.0;
            }
            if (rho < -1.0) {
                assert (rho >= -1.000001) : rho;
                rho = -1.0;
            }
            return Math.acos(rho) * this.semiMajor;
        }
        double lat1 = Math.toRadians(source.getY());
        double lat2 = Math.toRadians(target.getY());
        double lng1 = Math.toRadians(source.getX());
        double lng2 = Math.toRadians(target.getX());
        double dlat = Math.sin(0.5 * (lat2 - lat1));
        double dlng = Math.sin(0.5 * (lng2 - lng1));
        double x = dlat * dlat + dlng * dlng * Math.cos(lat1) * Math.cos(lat2);
        double arcRadians = 2.0 * Math.atan2(Math.sqrt(x), Math.sqrt(Math.max(0.0, 1.0 - x)));
        return arcRadians * this.semiMajor;
    }

    protected boolean checkReciprocal(Point2D point, Point2D target, boolean inverse) throws ProjectionException {
        if (SKIP_SANITY_CHECKS) {
            return true;
        }
        if (!(point instanceof CheckPoint)) {
            try {
                double latitude;
                double longitude;
                double distance;
                point = new CheckPoint(point);
                if (inverse) {
                    point = this.inverse().transform(point, point);
                    distance = this.orthodromicDistance(point, target);
                    longitude = point.getX();
                    latitude = point.getY();
                } else {
                    longitude = point.getX();
                    latitude = point.getY();
                    point = this.transform(point, point);
                    distance = point.distance(target);
                }
                if (distance > this.getToleranceForAssertions(longitude, latitude)) {
                    throw new ProjectionException(Errors.format(161, distance, new Longitude(longitude - Math.toDegrees(this.centralMeridian)), new Latitude(latitude - Math.toDegrees(this.latitudeOfOrigin)), this.getName()));
                }
            }
            catch (ProjectionException exception) {
                throw exception;
            }
            catch (TransformException exception) {
                throw new ProjectionException(exception);
            }
        }
        return true;
    }

    static boolean checkTransform(double x, double y, Point2D expected, double tolerance) {
        if (SKIP_SANITY_CHECKS) {
            return true;
        }
        MapProjection.compare("x", expected.getX(), x, tolerance);
        MapProjection.compare("y", expected.getY(), y, tolerance);
        return tolerance < Double.POSITIVE_INFINITY;
    }

    static boolean checkTransform(double x, double y, Point2D expected) {
        return MapProjection.checkTransform(x, y, expected, 1.0E-6);
    }

    static boolean checkInverseTransform(double longitude, double latitude, Point2D expected, double tolerance) {
        MapProjection.compare("latitude", expected.getY(), latitude, tolerance);
        if (Math.abs(1.5707963267948966 - Math.abs(latitude)) > 1.0E-6) {
            MapProjection.compare("longitude", expected.getX(), longitude, tolerance);
        }
        return tolerance < Double.POSITIVE_INFINITY;
    }

    static boolean checkInverseTransform(double longitude, double latitude, Point2D expected) {
        return MapProjection.checkInverseTransform(longitude, latitude, expected, 1.0E-6);
    }

    private static void compare(String variable, double expected, double actual, double tolerance) {
        if (Math.abs(expected - actual) > tolerance) {
            if (variable.charAt(0) == 'l') {
                actual = Math.toDegrees(actual);
                expected = Math.toDegrees(expected);
            }
            throw new AssertionError((Object)Errors.format(167, variable, expected, actual));
        }
    }

    protected abstract Point2D inverseTransformNormalized(double var1, double var3, Point2D var5) throws ProjectionException;

    protected abstract Point2D transformNormalized(double var1, double var3, Point2D var5) throws ProjectionException;

    @Override
    public final Point2D transform(Point2D ptSrc, Point2D ptDst) throws ProjectionException {
        double x = ptSrc.getX();
        double y = ptSrc.getY();
        if (this.verifyCoordinateRanges() && MapProjection.verifyGeographicRanges(this, x, y)) {
            this.warningLogged();
        }
        ptDst = this.transformNormalized(this.centralMeridian != 0.0 ? MapProjection.rollLongitude(Math.toRadians(x) - this.centralMeridian) : Math.toRadians(x), Math.toRadians(y), ptDst);
        ptDst.setLocation(this.globalScale * ptDst.getX() + this.falseEasting, this.globalScale * ptDst.getY() + this.falseNorthing);
        if (this.invertible) assert (this.checkReciprocal(ptDst, ptSrc != ptDst ? ptSrc : new Point2D.Double(x, y), true));
        return ptDst;
    }

    @Override
    public final void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws ProjectionException {
        boolean reverse;
        boolean bl = reverse = srcPts == dstPts && srcOff < dstOff && srcOff + 2 * numPts > dstOff;
        if (reverse) {
            srcOff += 2 * numPts;
            dstOff += 2 * numPts;
        }
        Point2D.Double point = new Point2D.Double();
        ProjectionException firstException = null;
        while (--numPts >= 0) {
            block5: {
                try {
                    point.x = srcPts[srcOff++];
                    point.y = srcPts[srcOff++];
                    this.transform(point, point);
                    dstPts[dstOff++] = point.x;
                    dstPts[dstOff++] = point.y;
                }
                catch (ProjectionException exception) {
                    dstPts[dstOff++] = Double.NaN;
                    dstPts[dstOff++] = Double.NaN;
                    if (firstException != null) break block5;
                    firstException = exception;
                }
            }
            if (!reverse) continue;
            srcOff -= 4;
            dstOff -= 4;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    @Override
    public final void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws ProjectionException {
        boolean reverse;
        boolean bl = reverse = srcPts == dstPts && srcOff < dstOff && srcOff + 2 * numPts > dstOff;
        if (reverse) {
            srcOff += 2 * numPts;
            dstOff += 2 * numPts;
        }
        Point2D.Double point = new Point2D.Double();
        ProjectionException firstException = null;
        while (--numPts >= 0) {
            block5: {
                try {
                    point.x = srcPts[srcOff++];
                    point.y = srcPts[srcOff++];
                    this.transform(point, point);
                    dstPts[dstOff++] = (float)point.x;
                    dstPts[dstOff++] = (float)point.y;
                }
                catch (ProjectionException exception) {
                    dstPts[dstOff++] = Float.NaN;
                    dstPts[dstOff++] = Float.NaN;
                    if (firstException != null) break block5;
                    firstException = exception;
                }
            }
            if (!reverse) continue;
            srcOff -= 4;
            dstOff -= 4;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    @Override
    public final MathTransform2D inverse() throws NoninvertibleTransformException {
        if (!this.invertible) {
            throw new NoninvertibleTransformException(Errors.format(105));
        }
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    protected double getToleranceForAssertions(double longitude, double latitude) {
        double delta = Math.abs(longitude - this.centralMeridian) / 2.0 + Math.abs(latitude - this.latitudeOfOrigin);
        if (delta > 40.0) {
            return 1.0;
        }
        return Math.abs(longitude) > 179.0 || Math.abs(latitude) > 89.0 ? 0.1 : 0.003;
    }

    final boolean verifyCoordinateRanges() {
        return this.rangeCheckSemaphore != globalRangeCheckSemaphore && !SKIP_SANITY_CHECKS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void warningLogged() {
        Class<MapProjection> clazz = MapProjection.class;
        synchronized (MapProjection.class) {
            this.rangeCheckSemaphore = globalRangeCheckSemaphore;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void resetWarnings() {
        ++globalRangeCheckSemaphore;
    }

    @Override
    public int hashCode() {
        long code = Double.doubleToLongBits(this.semiMajor);
        code = code * 37L + Double.doubleToLongBits(this.semiMinor);
        code = code * 37L + Double.doubleToLongBits(this.centralMeridian);
        code = code * 37L + Double.doubleToLongBits(this.latitudeOfOrigin);
        return (int)code ^ (int)(code >>> 32);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            MapProjection that = (MapProjection)object;
            return MapProjection.equals(this.semiMajor, that.semiMajor) && MapProjection.equals(this.semiMinor, that.semiMinor) && MapProjection.equals(this.centralMeridian, that.centralMeridian) && MapProjection.equals(this.latitudeOfOrigin, that.latitudeOfOrigin) && MapProjection.equals(this.scaleFactor, that.scaleFactor) && MapProjection.equals(this.falseEasting, that.falseEasting) && MapProjection.equals(this.falseNorthing, that.falseNorthing);
        }
        return false;
    }

    static boolean equals(double value1, double value2) {
        return Utilities.equals(value1, value2);
    }

    final double cphi2(double ts) throws ProjectionException {
        double eccnth = 0.5 * this.excentricity;
        double phi = 1.5707963267948966 - 2.0 * Math.atan(ts);
        for (int i = 0; i < 15; ++i) {
            double con = this.excentricity * Math.sin(phi);
            double dphi = 1.5707963267948966 - 2.0 * Math.atan(ts * Math.pow((1.0 - con) / (1.0 + con), eccnth)) - phi;
            phi += dphi;
            if (!(Math.abs(dphi) <= 1.0E-10)) continue;
            return phi;
        }
        throw new ProjectionException(129);
    }

    final double msfn(double s, double c) {
        return c / Math.sqrt(1.0 - s * s * this.excentricitySquared);
    }

    final double tsfn(double phi, double sinphi) {
        return Math.tan(0.5 * (1.5707963267948966 - phi)) / Math.pow((1.0 - (sinphi *= this.excentricity)) / (1.0 + sinphi), 0.5 * this.excentricity);
    }

    protected final double mlfn(double phi, double sphi, double cphi) {
        cphi *= sphi;
        sphi *= sphi;
        return this.en0 * phi - cphi * (this.en1 + sphi * (this.en2 + sphi * (this.en3 + sphi * this.en4)));
    }

    protected final double inv_mlfn(double arg) throws ProjectionException {
        double t;
        double k = 1.0 / (1.0 - this.excentricitySquared);
        double phi = arg;
        int i = 15;
        do {
            if (--i < 0) {
                throw new ProjectionException(Errors.format(129));
            }
            double s = Math.sin(phi);
            t = 1.0 - this.excentricitySquared * s * s;
            t = (this.mlfn(phi, s, Math.cos(phi)) - arg) * (t * Math.sqrt(t)) * k;
            phi -= t;
        } while (!(Math.abs(t) < 1.0E-11));
        return phi;
    }

    double aasin(double v) {
        double av = Math.abs(v);
        if (av >= 1.0) {
            return v < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        return Math.asin(v);
    }

    public static abstract class AbstractProvider
    extends MathTransformProvider {
        private static final long serialVersionUID = 6280666068007678702L;
        public static final ParameterDescriptor<Double> SEMI_MAJOR = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_major"), new NamedIdentifier(Citations.EPSG, "semi-major axis")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METRE);
        public static final ParameterDescriptor<Double> SEMI_MINOR = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_minor"), new NamedIdentifier(Citations.EPSG, "semi-minor axis")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METRE);
        public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "central_meridian"), new NamedIdentifier(Citations.EPSG, "Longitude of natural origin"), new NamedIdentifier(Citations.EPSG, "Longitude of false origin"), new NamedIdentifier(Citations.EPSG, "Longitude of origin"), new NamedIdentifier(Citations.ESRI, "Longitude_Of_Center"), new NamedIdentifier(Citations.ESRI, "longitude_of_center"), new NamedIdentifier(Citations.ESRI, "Longitude_Of_Origin"), new NamedIdentifier(Citations.ESRI, "longitude_of_origin"), new NamedIdentifier(Citations.GEOTIFF, "NatOriginLong")}, 0.0, -180.0, 180.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "latitude_of_origin"), new NamedIdentifier(Citations.EPSG, "Latitude of false origin"), new NamedIdentifier(Citations.EPSG, "Latitude of natural origin"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Origin"), new NamedIdentifier(Citations.ESRI, "latitude_of_origin"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Center"), new NamedIdentifier(Citations.ESRI, "latitude_of_center"), new NamedIdentifier(Citations.GEOTIFF, "NatOriginLat")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor<Double> LONGITUDE_OF_CENTRE = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "longitude_of_center"), new NamedIdentifier(Citations.OGC, "longitude_of_origin"), new NamedIdentifier(Citations.EPSG, "Longitude of natural origin"), new NamedIdentifier(Citations.EPSG, "Spherical longitude of origin"), new NamedIdentifier(Citations.ESRI, "Central_Meridian"), new NamedIdentifier(Citations.GEOTIFF, "ProjCenterLong")}, 0.0, -180.0, 180.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor<Double> LATITUDE_OF_CENTRE = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "latitude_of_center"), new NamedIdentifier(Citations.OGC, "latitude_of_origin"), new NamedIdentifier(Citations.EPSG, "Latitude of natural origin"), new NamedIdentifier(Citations.EPSG, "Spherical latitude of origin"), new NamedIdentifier(Citations.ESRI, "Latitude_Of_Origin"), new NamedIdentifier(Citations.GEOTIFF, "ProjCenterLat")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor<Double> STANDARD_PARALLEL_1 = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "standard_parallel_1"), new NamedIdentifier(Citations.EPSG, "Latitude of 1st standard parallel"), new NamedIdentifier(Citations.ESRI, "Standard_Parallel_1"), new NamedIdentifier(Citations.ESRI, "standard_parallel_1"), new NamedIdentifier(Citations.GEOTIFF, "StdParallel1")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor<Double> STANDARD_PARALLEL_2 = AbstractProvider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "standard_parallel_2"), new NamedIdentifier(Citations.EPSG, "Latitude of 2nd standard parallel"), new NamedIdentifier(Citations.ESRI, "Standard_Parallel_2"), new NamedIdentifier(Citations.ESRI, "standard_parallel_2"), new NamedIdentifier(Citations.GEOTIFF, "StdParallel2")}, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor<Double> SCALE_FACTOR = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "scale_factor"), new NamedIdentifier(Citations.EPSG, "Scale factor at natural origin"), new NamedIdentifier(Citations.EPSG, "Scale factor on initial line"), new NamedIdentifier(Citations.GEOTIFF, "ScaleAtNatOrigin"), new NamedIdentifier(Citations.GEOTIFF, "ScaleAtCenter"), new NamedIdentifier(Citations.ESRI, "Scale_Factor"), new NamedIdentifier(Citations.ESRI, "scale_factor")}, 1.0, 0.0, Double.POSITIVE_INFINITY, AbstractUnit.ONE);
        public static final ParameterDescriptor<Double> FALSE_EASTING = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "false_easting"), new NamedIdentifier(Citations.EPSG, "False easting"), new NamedIdentifier(Citations.EPSG, "Easting at false origin"), new NamedIdentifier(Citations.EPSG, "Easting at projection centre"), new NamedIdentifier(Citations.GEOTIFF, "FalseEasting"), new NamedIdentifier(Citations.ESRI, "False_Easting")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METRE);
        public static final ParameterDescriptor<Double> FALSE_NORTHING = AbstractProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "false_northing"), new NamedIdentifier(Citations.EPSG, "False northing"), new NamedIdentifier(Citations.EPSG, "Northing at false origin"), new NamedIdentifier(Citations.EPSG, "Northing at projection centre"), new NamedIdentifier(Citations.GEOTIFF, "FalseNorthing"), new NamedIdentifier(Citations.ESRI, "False_Northing"), new NamedIdentifier(Citations.ESRI, "false_northing")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METRE);

        public AbstractProvider(ParameterDescriptorGroup parameters) {
            super(2, 2, parameters);
        }

        public Class<? extends Projection> getOperationType() {
            return Projection.class;
        }

        static boolean isSpherical(ParameterValueGroup values) {
            try {
                return MathTransformProvider.doubleValue(SEMI_MAJOR, values) == MathTransformProvider.doubleValue(SEMI_MINOR, values);
            }
            catch (IllegalStateException exception) {
                return false;
            }
        }

        protected static double doubleValue(ParameterDescriptor param, ParameterValueGroup group) throws ParameterNotFoundException {
            double v = MathTransformProvider.doubleValue(param, group);
            if (NonSI.DEGREE_ANGLE.equals(param.getUnit())) {
                v = Math.toRadians(v);
            }
            return v;
        }
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements MathTransform2D {
        private static final long serialVersionUID = -9138242780765956870L;

        public Inverse() {
            super(MapProjection.this);
        }

        @Override
        public final Point2D transform(Point2D ptSrc, Point2D ptDst) throws ProjectionException {
            double x0 = ptSrc.getX();
            double y0 = ptSrc.getY();
            ptDst = MapProjection.this.inverseTransformNormalized((x0 - MapProjection.this.falseEasting) / MapProjection.this.globalScale, (y0 - MapProjection.this.falseNorthing) / MapProjection.this.globalScale, ptDst);
            double x = Math.toDegrees(MapProjection.this.centralMeridian != 0.0 ? Inverse.rollLongitude(ptDst.getX() + MapProjection.this.centralMeridian) : ptDst.getX());
            double y = Math.toDegrees(ptDst.getY());
            ptDst.setLocation(x, y);
            if (MapProjection.this.verifyCoordinateRanges() && MapProjection.verifyGeographicRanges(this, x, y)) {
                MapProjection.this.warningLogged();
            }
            assert (MapProjection.this.checkReciprocal(ptDst, ptSrc != ptDst ? ptSrc : new Point2D.Double(x0, y0), false));
            return ptDst;
        }

        @Override
        public final void transform(double[] src, int srcOffset, double[] dest, int dstOffset, int numPts) throws TransformException {
            boolean reverse;
            boolean bl = reverse = src == dest && srcOffset < dstOffset && srcOffset + 2 * numPts > dstOffset;
            if (reverse) {
                srcOffset += 2 * numPts;
                dstOffset += 2 * numPts;
            }
            Point2D.Double point = new Point2D.Double();
            ProjectionException firstException = null;
            while (--numPts >= 0) {
                block5: {
                    try {
                        point.x = src[srcOffset++];
                        point.y = src[srcOffset++];
                        this.transform(point, point);
                        dest[dstOffset++] = point.x;
                        dest[dstOffset++] = point.y;
                    }
                    catch (ProjectionException exception) {
                        dest[dstOffset++] = Double.NaN;
                        dest[dstOffset++] = Double.NaN;
                        if (firstException != null) break block5;
                        firstException = exception;
                    }
                }
                if (!reverse) continue;
                srcOffset -= 4;
                dstOffset -= 4;
            }
            if (firstException != null) {
                throw firstException;
            }
        }

        @Override
        public final void transform(float[] src, int srcOffset, float[] dest, int dstOffset, int numPts) throws ProjectionException {
            boolean reverse;
            boolean bl = reverse = src == dest && srcOffset < dstOffset && srcOffset + 2 * numPts > dstOffset;
            if (reverse) {
                srcOffset += 2 * numPts;
                dstOffset += 2 * numPts;
            }
            Point2D.Double point = new Point2D.Double();
            ProjectionException firstException = null;
            while (--numPts >= 0) {
                block5: {
                    try {
                        point.x = src[srcOffset++];
                        point.y = src[srcOffset++];
                        this.transform(point, point);
                        dest[dstOffset++] = (float)point.x;
                        dest[dstOffset++] = (float)point.y;
                    }
                    catch (ProjectionException exception) {
                        dest[dstOffset++] = Float.NaN;
                        dest[dstOffset++] = Float.NaN;
                        if (firstException != null) break block5;
                        firstException = exception;
                    }
                }
                if (!reverse) continue;
                srcOffset -= 4;
                dstOffset -= 4;
            }
            if (firstException != null) {
                throw firstException;
            }
        }

        @Override
        public MathTransform2D inverse() {
            return (MathTransform2D)super.inverse();
        }
    }

    private static final class CheckPoint
    extends Point2D.Double {
        public CheckPoint(Point2D point) {
            super(point.getX(), point.getY());
        }
    }
}

