/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.factory.IdentifiedObjectSet;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

final class CoordinateOperationSet
extends IdentifiedObjectSet {
    private static final long serialVersionUID = -2421669857023064667L;
    private Map<String, String> projections;

    public CoordinateOperationSet(AuthorityFactory factory) {
        super(factory);
    }

    public boolean addAuthorityCode(String code, String crs) {
        if (crs != null) {
            if (this.projections == null) {
                this.projections = new HashMap<String, String>();
            }
            this.projections.put(code, crs);
        }
        return super.addAuthorityCode(code);
    }

    @Override
    protected IdentifiedObject createObject(String code) throws FactoryException {
        String crs;
        if (this.projections != null && (crs = this.projections.get(code)) != null) {
            return ((CRSAuthorityFactory)this.factory).createProjectedCRS(crs).getConversionFromBase();
        }
        return ((CoordinateOperationAuthorityFactory)this.factory).createCoordinateOperation(code);
    }
}

