/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.Arrays;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.capability.FunctionName;

public class InArrayFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("inArray", FunctionNameImpl.parameter("inArray", Boolean.class, "InArray", "Returns true if any array value matches candidate."), FunctionNameImpl.parameter("candidate", Object.class, "Candidate", "value to match with array"), FunctionNameImpl.parameter("array", Object[].class, "Array", "array of values"));

    public InArrayFunction() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        Object candidate = this.getExpression(0).evaluate(feature);
        Object[] array = this.getExpression(1).evaluate(feature, Object[].class);
        if (candidate == null || array == null) {
            return Boolean.FALSE;
        }
        return Arrays.asList(array).contains(candidate);
    }
}

