/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageio.utilities.SoftValueHashMap;
import it.geosolutions.imageioimpl.plugins.cog.RangeReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;

public abstract class AbstractRangeReader
implements RangeReader {
    protected static final Map<String, byte[]> HEADERS_CACHE = new SoftValueHashMap<String, byte[]>();
    protected BasicAuthURI authUri;
    protected URI uri;
    protected SoftValueHashMap<Long, byte[]> data = new SoftValueHashMap(0);
    protected int headerLength;
    protected int headerOffset = 0;
    private static final Logger LOGGER = Logger.getLogger(AbstractRangeReader.class.getName());

    public AbstractRangeReader(BasicAuthURI authUri, int headerLength) {
        this.authUri = authUri;
        this.uri = authUri.getUri();
        this.headerLength = headerLength;
    }

    protected long[][] reconcileRanges(long[][] ranges) {
        boolean modified = false;
        ArrayList<long[]> newRanges = new ArrayList<long[]>();
        for (int i = 0; i < ranges.length; ++i) {
            int dataLength = this.headerLength;
            if (ranges[i][0] < (long)(dataLength - 1)) {
                modified = true;
                if (ranges[i][1] <= (long)(dataLength - 1)) {
                    LOGGER.fine("Removed range " + ranges[i][0] + "-" + ranges[i][1] + " as it lies fully within the data already read in the header request");
                    continue;
                }
                long[] newRange = new long[]{dataLength - 1, ranges[i][1]};
                byte[] headersData = this.data.get(0L);
                if (headersData != null && dataLength < headersData.length) {
                    byte[] newHeader = new byte[dataLength];
                    System.arraycopy(headersData, 0, newHeader, 0, dataLength);
                    this.data.put(0L, newHeader);
                    HEADERS_CACHE.put(this.uri.toString(), newHeader);
                }
                newRanges.add(newRange);
                LOGGER.fine("Modified range " + ranges[i][0] + "-" + ranges[i][1] + " to " + dataLength + "-" + ranges[i][1] + " as it overlaps with data previously read in the header request");
                continue;
            }
            newRanges.add(ranges[i]);
        }
        if (modified) {
            return (long[][])newRanges.toArray((T[])new long[0][]);
        }
        LOGGER.fine("No ranges modified.");
        return ranges;
    }

    @Override
    public void setHeaderLength(int headerLength) {
        this.headerLength = headerLength;
    }

    @Override
    public int getHeaderLength() {
        return this.headerOffset + this.headerLength;
    }

    public static void invalidateCache() {
        HEADERS_CACHE.clear();
    }
}

