/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.polygonize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;

public class PolygonizerPerfTest
extends PerformanceTestCase {
    private static final int BUFFER_SEGS = 10;
    GeometryFactory geomFact = new GeometryFactory();
    private Geometry testCircles;

    public static void main(String[] args) {
        PerformanceTestRunner.run(PolygonizerPerfTest.class);
    }

    public PolygonizerPerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{10, 1000, 2000});
        this.setRunIterations(1);
    }

    @Override
    public void startRun(int num) {
        System.out.println("Running with size " + num);
        double size = 100.0;
        List<Polygon> polys = this.createCircleGrid(num, size, 10);
        Polygon surround = this.createAnnulus(size / 2.0, size / 2.0, 2.0 * size, size, 10000);
        polys.add(surround);
        this.testCircles = this.geomFact.createMultiPolygon(GeometryFactory.toPolygonArray(polys));
    }

    private List<Polygon> createCircleGrid(int num, double size, int bufferSegs) {
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        int nOnSide = (int)Math.sqrt(num) + 1;
        double radius = size / (double)nOnSide / 4.0;
        double gap = 4.0 * radius;
        for (int index = 0; index < num; ++index) {
            int iy = index / nOnSide;
            int ix = index % nOnSide;
            double x = (double)ix * gap;
            double y = (double)iy * gap;
            Polygon poly = this.createAnnulus(x, y, radius, radius / 2.0, bufferSegs);
            polys.add(poly);
        }
        return polys;
    }

    private Polygon createAnnulus(double x, double y, double radius, double innerRadius, int bufferSegs) {
        Point pt = this.geomFact.createPoint(new Coordinate(x, y));
        LinearRing shell = this.bufferRing(pt, radius, bufferSegs);
        LinearRing hole = this.bufferRing(pt, innerRadius, bufferSegs);
        return pt.getFactory().createPolygon(shell, new LinearRing[]{hole});
    }

    private LinearRing bufferRing(Point pt, double radius, int bufferSegs) {
        Polygon buf = (Polygon)pt.buffer(radius, bufferSegs);
        return buf.getExteriorRing();
    }

    public void runDisjointCirclesInsideDonut() {
        boolean extractOnlyPolygonal = false;
        Polygonizer polygonizer = new Polygonizer(extractOnlyPolygonal);
        polygonizer.add(this.testCircles);
        Collection output = polygonizer.getPolygons();
    }
}

