/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.overlay;

import java.util.Random;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import test.jts.perf.operation.overlay.RotatedRectangleFactory;

public class OverlayNodingStressTest
extends TestCase {
    private static final int ITER_LIMIT = 10000;
    private static final int BATCH_SIZE = 20;
    private Random rand = new Random(3141592653L);
    private int failureCount = 0;
    private static final double MAX_DISPLACEMENT = 60.0;
    private Geometry baseAccum = null;
    private int geomCount = 0;

    public OverlayNodingStressTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(OverlayNodingStressTest.class);
    }

    private double getRand() {
        double r = this.rand.nextDouble();
        return r;
    }

    public void testNoding() {
        int iterLimit = 10000;
        for (int i = 0; i < iterLimit; ++i) {
            System.out.println("Iter: " + i + "  Noding failure count = " + this.failureCount);
            double ang1 = this.getRand() * Math.PI;
            double ang2 = this.getRand() * Math.PI;
            Geometry[] geom = this.generateGeometryAccum(ang1, ang2);
            this.checkIntersection(geom[0], geom[1]);
        }
        System.out.println("Test count = " + iterLimit + "  Noding failure count = " + this.failureCount);
    }

    public Geometry[] generateGeometryStar(double angle1, double angle2) {
        RotatedRectangleFactory rrFact = new RotatedRectangleFactory();
        Polygon rr1 = rrFact.createRectangle(100.0, 20.0, angle1);
        Polygon rr2 = rrFact.createRectangle(100.0, 20.0, angle2);
        Geometry star = rr1.union(rr2);
        return new Geometry[]{star, rr1};
    }

    public Geometry[] generateGeometryAccum(double angle1, double angle2) {
        RotatedRectangleFactory rrFact = new RotatedRectangleFactory();
        double basex = angle2 * 60.0 - 30.0;
        Coordinate base = new Coordinate(basex, basex);
        Polygon rr1 = rrFact.createRectangle(100.0, 20.0, angle1, base);
        ++this.geomCount;
        if (this.geomCount >= 20) {
            this.geomCount = 0;
        }
        if (this.geomCount == 0) {
            this.baseAccum = null;
        }
        this.baseAccum = this.baseAccum == null ? rr1 : rr1.union(this.baseAccum);
        return new Geometry[]{this.baseAccum, rr1};
    }

    public void checkIntersection(Geometry base, Geometry testGeom) {
        System.out.println("Star:");
        System.out.println(base);
        System.out.println("Rectangle:");
        System.out.println(testGeom);
        try {
            Geometry geometry = base.intersection(testGeom);
        }
        catch (Exception ex) {
            ++this.failureCount;
        }
        Geometry intersection = SnapIfNeededOverlayOp.intersection(base, testGeom);
        System.out.println("Intersection:");
        System.out.println(intersection);
    }
}

