/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.buffer;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.buffer.validate.BufferResultValidator;
import test.jts.perf.operation.buffer.RandomOffsetLineStringGenerator;

public class RandomLineBufferStressTest {
    private PrecisionModel precisionModel = new PrecisionModel();
    private GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader rdr = new WKTReader(this.geometryFactory);
    private int caseCount = 0;

    public static void main(String[] args) {
        try {
            new RandomLineBufferStressTest().run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void run() throws Exception {
        while (true) {
            this.run(10);
            this.run(100);
            this.run(200);
        }
    }

    void run(int numPts) throws Exception {
        double lineScale = 1.0;
        Geometry line = RandomOffsetLineStringGenerator.generate(lineScale, numPts, this.geometryFactory);
        System.out.println();
        System.out.println(line);
        this.runCase(line, 10.0, lineScale, numPts);
        this.runCase(line, 1.0, lineScale, numPts);
        this.runCase(line, 0.1, lineScale, numPts);
    }

    void runCase(Geometry line, double dist, double lineScale, int numPts) throws Exception {
        ++this.caseCount;
        System.out.println("Running case " + this.caseCount + "  (line scale = " + lineScale + "  buffer dist = " + dist + "  num pts = " + numPts + " )");
        this.checkBuffer(line, dist);
    }

    void checkBuffer(Geometry g, double distance) {
        Geometry buf = g.buffer(distance);
        String isValidMsg = BufferResultValidator.isValidMsg(g, distance, buf);
        if (isValidMsg != null) {
            System.out.println("Input: ");
            System.out.println(g);
            System.out.println("Buffer: ");
            System.out.println(buf);
            throw new IllegalStateException(isValidMsg);
        }
    }
}

