/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.buffer;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.util.Stopwatch;

public class IteratedBufferStressTest {
    private PrecisionModel precisionModel = new PrecisionModel();
    private GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader rdr = new WKTReader(this.geometryFactory);
    String inputWKT = "POLYGON ((110 320, 190 220, 60 200, 180 120, 120 40, 290 150, 410 40, 410 230, 500 340, 320 310, 260 370, 220 310, 110 320), (220 260, 250 180, 290 220, 360 150, 350 250, 260 280, 220 260))";

    public static void main(String[] args) {
        try {
            new IteratedBufferStressTest().run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void run() throws Exception {
        Stopwatch totalSW = new Stopwatch();
        Geometry base = this.rdr.read(this.inputWKT);
        double dist = 1.0;
        while (!base.isEmpty()) {
            Geometry b1 = this.doBuffer(base, dist);
            Geometry b2 = this.doBuffer(b1, -dist);
            dist += 1.0;
            base = b2;
            System.out.println("----------------------  " + totalSW.getTimeString());
            System.out.println();
        }
    }

    Geometry doBuffer(Geometry g, double dist) {
        System.out.println("Buffering with dist = " + dist);
        Geometry buf = g.buffer(dist);
        System.out.println("Buffer result has " + buf.getNumPoints() + " vertices");
        System.out.println(buf);
        return buf;
    }
}

