/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.geom.prep;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.geom.util.SineStarFactory;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.util.Stopwatch;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;

public class PreparedPolygonCoversPerfTest
extends PerformanceTestCase {
    static final int NUM_ITER = 10000;
    static final int NUM_PTS = 2000;
    static PrecisionModel pm = new PrecisionModel();
    static GeometryFactory fact = new GeometryFactory(pm, 0);
    static WKTReader wktRdr = new WKTReader(fact);
    static WKTWriter wktWriter = new WKTWriter();
    Stopwatch sw = new Stopwatch();
    boolean testFailed = false;
    private PreparedGeometry prepGeom;
    private List<Point> testPoints;
    private Geometry sinePoly;

    public static void main(String[] args) {
        PerformanceTestRunner.run(PreparedPolygonCoversPerfTest.class);
    }

    public PreparedPolygonCoversPerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{1000});
        this.setRunIterations(1);
    }

    @Override
    public void startRun(int nPts) {
        System.out.println("Running with size " + nPts);
        System.out.println("Iterations per run = 10000");
        this.sinePoly = this.createSineStar(new Coordinate(0.0, 0.0), 100.0, nPts);
        this.prepGeom = new PreparedGeometryFactory().create(this.sinePoly);
        this.testPoints = this.createPoints(this.sinePoly.getEnvelopeInternal(), 2000);
    }

    Geometry createSineStar(Coordinate origin, double size, int nPts) {
        SineStarFactory gsf = new SineStarFactory();
        gsf.setCentre(origin);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        gsf.setArmLengthRatio(0.1);
        gsf.setNumArms(50);
        Geometry poly = gsf.createSineStar();
        return poly;
    }

    List<Point> createPoints(Envelope env, int nPts) {
        int nCells = (int)Math.sqrt(nPts);
        ArrayList<Point> geoms = new ArrayList<Point>();
        double width = env.getWidth();
        double xInc = width / (double)nCells;
        double yInc = width / (double)nCells;
        for (int i = 0; i < nCells; ++i) {
            for (int j = 0; j < nCells; ++j) {
                Coordinate base = new Coordinate(env.getMinX() + (double)i * xInc, env.getMinY() + (double)j * yInc);
                Point pt = fact.createPoint(base);
                geoms.add(pt);
            }
        }
        return geoms;
    }

    public void runPreparedPolygon() {
        for (int i = 0; i < 10000; ++i) {
            this.prepGeom = new PreparedGeometryFactory().create(this.sinePoly);
            for (Point pt : this.testPoints) {
                this.prepGeom.covers(pt);
            }
        }
    }

    public void runIndexPointInAreaLocator() {
        for (int i = 0; i < 10000; ++i) {
            IndexedPointInAreaLocator ipa = new IndexedPointInAreaLocator(this.sinePoly);
            for (Point pt : this.testPoints) {
                ipa.locate(pt.getCoordinate());
            }
        }
    }
}

