/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.util.Stopwatch;

public class PointInAreaPerfTester {
    private GeometryFactory geomFactory;
    private Geometry area;
    private int numPts = 10000;
    private PointOnGeometryLocator pia1;
    private int[] locationCount = new int[3];

    public PointInAreaPerfTester(GeometryFactory geomFactory, Geometry area) {
        this.geomFactory = geomFactory;
        this.area = area;
    }

    public void setNumPoints(int numPoints) {
        this.numPts = numPoints;
    }

    public void setPIA(PointOnGeometryLocator pia) {
        this.pia1 = pia;
    }

    public boolean run() {
        Stopwatch sw = new Stopwatch();
        int ptGridWidth = (int)Math.sqrt(this.numPts);
        Envelope areaEnv = this.area.getEnvelopeInternal();
        double xStep = areaEnv.getWidth() / (double)(ptGridWidth - 1);
        double yStep = areaEnv.getHeight() / (double)(ptGridWidth - 1);
        for (int i = 0; i < ptGridWidth; ++i) {
            for (int j = 0; j < ptGridWidth; ++j) {
                int loc;
                double x = areaEnv.getMinX() + (double)i * xStep;
                double y = areaEnv.getMinY() + (double)j * yStep;
                Coordinate pt = new Coordinate(x, y);
                this.geomFactory.getPrecisionModel().makePrecise(pt);
                int n = loc = this.pia1.locate(pt);
                this.locationCount[n] = this.locationCount[n] + 1;
            }
        }
        System.out.println("Test completed in " + sw.getTimeString());
        this.printStats();
        return true;
    }

    public void printStats() {
        System.out.println("Location counts:  Boundary = " + this.locationCount[1] + " Interior = " + this.locationCount[0] + " Exterior = " + this.locationCount[2]);
    }
}

