/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

public class SameStructureTester {
    public static boolean isSameStructure(Geometry g1, Geometry g2) {
        if (g1.getClass() != g2.getClass()) {
            return false;
        }
        if (g1 instanceof GeometryCollection) {
            return SameStructureTester.isSameStructureCollection((GeometryCollection)g1, (GeometryCollection)g2);
        }
        if (g1 instanceof Polygon) {
            return SameStructureTester.isSameStructurePolygon((Polygon)g1, (Polygon)g2);
        }
        if (g1 instanceof LineString) {
            return SameStructureTester.isSameStructureLineString((LineString)g1, (LineString)g2);
        }
        if (g1 instanceof Point) {
            return SameStructureTester.isSameStructurePoint((Point)g1, (Point)g2);
        }
        Assert.shouldNeverReachHere("Unsupported Geometry class: " + g1.getClass().getName());
        return false;
    }

    private static boolean isSameStructureCollection(GeometryCollection g1, GeometryCollection g2) {
        if (g1.getNumGeometries() != g2.getNumGeometries()) {
            return false;
        }
        for (int i = 0; i < g1.getNumGeometries(); ++i) {
            if (SameStructureTester.isSameStructure(g1.getGeometryN(i), g2.getGeometryN(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameStructurePolygon(Polygon g1, Polygon g2) {
        return g1.getNumInteriorRing() == g2.getNumInteriorRing();
    }

    private static boolean isSameStructureLineString(LineString g1, LineString g2) {
        return true;
    }

    private static boolean isSameStructurePoint(Point g1, Point g2) {
        return true;
    }

    private SameStructureTester() {
    }
}

