/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import test.jts.GeometryTestCase;

public class OverlayNGInvalidTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(OverlayNGInvalidTest.class);
    }

    public OverlayNGInvalidTest(String name) {
        super(name);
    }

    public void testPolygonFlatIntersection() {
        Geometry a = this.read("POLYGON ((10 40, 40 40, 40 10, 10 10, 10 40))");
        Geometry b = this.read("POLYGON ((50 30, 19 30, 50 30))");
        Geometry expected = this.read("LINESTRING (40 30, 19 30)");
        this.checkEqualExact(expected, OverlayNGInvalidTest.intersection(a, b));
    }

    public void testPolygonAdjacentElementIntersection() {
        Geometry a = this.read("MULTIPOLYGON (((10 10, 10 40, 40 40, 40 10, 10 10)), ((70 10, 40 10, 40 40, 70 40, 70 10)))");
        Geometry b = this.read("POLYGON ((20 50, 60 50, 60 20, 20 20, 20 50))");
        Geometry expected = this.read("POLYGON ((40 40, 60 40, 60 20, 40 20, 20 20, 20 40, 40 40))");
        this.checkEqualExact(expected, OverlayNGInvalidTest.intersection(a, b));
    }

    public void testPolygonInvertedIntersection() {
        Geometry a = this.read("POLYGON ((10 40, 70 40, 70 0, 40 0, 50 20, 30 20, 40 0, 10 0, 10 40))");
        Geometry b = this.read("POLYGON ((20 50, 60 50, 60 10, 20 10, 20 50))");
        Geometry expected = this.read("POLYGON ((60 40, 60 10, 45 10, 50 20, 30 20, 35 10, 20 10, 20 40, 60 40))");
        this.checkEqualExact(expected, OverlayNGInvalidTest.intersection(a, b));
    }

    public void testPolygonExvertedIntersection() {
        Geometry a = this.read("POLYGON ((10 30, 70 30, 70 0, 40 30, 10 0, 10 30))");
        Geometry b = this.read("POLYGON ((20 50, 60 50, 60 10, 20 10, 20 50))");
        Geometry expected = this.read("MULTIPOLYGON (((40 30, 20 10, 20 30, 40 30)), ((60 30, 60 10, 40 30, 60 30)))");
        this.checkEqualExact(expected, OverlayNGInvalidTest.intersection(a, b));
    }

    public static Geometry difference(Geometry a, Geometry b) {
        PrecisionModel pm = new PrecisionModel();
        return OverlayNG.overlay(a, b, 3, pm);
    }

    public static Geometry symDifference(Geometry a, Geometry b) {
        PrecisionModel pm = new PrecisionModel();
        return OverlayNG.overlay(a, b, 4, pm);
    }

    public static Geometry intersection(Geometry a, Geometry b) {
        PrecisionModel pm = new PrecisionModel();
        return OverlayNG.overlay(a, b, 1, pm);
    }

    public static Geometry union(Geometry a, Geometry b) {
        PrecisionModel pm = new PrecisionModel();
        return OverlayNG.overlay(a, b, 2, pm);
    }
}

