/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.noding.snapround.GeometryNoder;

public class SnapRoundingTest
extends TestCase {
    WKTReader rdr = new WKTReader();
    static final double SNAP_TOLERANCE = 1.0;

    public static void main(String[] args) {
        TestRunner.run(SnapRoundingTest.class);
    }

    public SnapRoundingTest(String name) {
        super(name);
    }

    public void testPolyWithCloseNode() {
        String[] polyWithCloseNode = new String[]{"POLYGON ((20 0, 20 160, 140 1, 160 160, 160 1, 20 0))"};
        this.checkRounding(polyWithCloseNode);
    }

    public void testPolyWithCloseNodeFrac() {
        String[] polyWithCloseNode = new String[]{"POLYGON ((20 0, 20 160, 140 0.2, 160 160, 160 0, 20 0))"};
        this.checkRounding(polyWithCloseNode);
    }

    public void testLineStringLongShort() {
        String[] geoms = new String[]{"LINESTRING (0 0, 2 0)", "LINESTRING (0 0, 10 -1)"};
        this.checkRounding(geoms);
    }

    public void testBadLines1() {
        String[] badLines1 = new String[]{"LINESTRING ( 171 157, 175 154, 170 154, 170 155, 170 156, 170 157, 171 158, 171 159, 172 160, 176 156, 171 156, 171 159, 176 159, 172 155, 170 157, 174 161, 174 156, 173 156, 172 156 )"};
        this.checkRounding(badLines1);
    }

    public void testBadLines2() {
        String[] badLines2 = new String[]{"LINESTRING ( 175 222, 176 222, 176 219, 174 221, 175 222, 177 220, 174 220, 174 222, 177 222, 175 220, 174 221 )"};
        this.checkRounding(badLines2);
    }

    public void testCollapse1() {
        String[] collapse1 = new String[]{"LINESTRING ( 362 177, 375 164, 374 164, 372 161, 373 163, 372 165, 373 164, 442 58 )"};
        this.checkRounding(collapse1);
    }

    public void testCollapse2() {
        String[] collapse2 = new String[]{"LINESTRING ( 393 175, 391 173, 390 175, 391 174, 391 173 )"};
        this.checkRounding(collapse2);
    }

    public void testLineWithManySelfSnaps() {
        String[] line = new String[]{"LINESTRING (0 0, 6 4, 8 11, 13 13, 14 12, 11 12, 7 7, 7 3, 4 2)"};
        this.checkRounding(line);
    }

    public void testBadNoding1() {
        String[] badNoding1 = new String[]{"LINESTRING ( 76 47, 81 52, 81 53, 85 57, 88 62, 89 64, 57 80, 82 55, 101 74, 76 99, 92 67, 94 68, 99 71, 103 75, 139 111 )"};
        this.checkRounding(badNoding1);
    }

    public void testBadNoding1Extract() {
        String[] badNoding1Extract = new String[]{"LINESTRING ( 82 55, 101 74 )", "LINESTRING ( 94 68, 99 71 )", "LINESTRING ( 85 57, 88 62 )"};
        this.checkRounding(badNoding1Extract);
    }

    public void testBadNoding1ExtractShift() {
        String[] badNoding1ExtractShift = new String[]{"LINESTRING ( 0 0, 19 19 )", "LINESTRING ( 12 13, 17 16 )", "LINESTRING ( 3 2, 6 7 )"};
        this.checkRounding(badNoding1ExtractShift);
    }

    void checkRounding(String[] wkt) {
        List geoms = this.fromWKT(wkt);
        PrecisionModel pm = new PrecisionModel(1.0);
        GeometryNoder noder = new GeometryNoder(pm);
        noder.setValidate(true);
        List nodedLines = noder.node(geoms);
        SnapRoundingTest.assertTrue((boolean)this.isSnapped(nodedLines, 1.0));
    }

    List fromWKT(String[] wkts) {
        ArrayList<Geometry> geomList = new ArrayList<Geometry>();
        for (int i = 0; i < wkts.length; ++i) {
            try {
                geomList.add(this.rdr.read(wkts[i]));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return geomList;
    }

    boolean isSnapped(List lines, double tol) {
        for (int i = 0; i < lines.size(); ++i) {
            LineString line = (LineString)lines.get(i);
            for (int j = 0; j < line.getNumPoints(); ++j) {
                Coordinate v = line.getCoordinateN(j);
                if (this.isSnapped(v, lines)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSnapped(Coordinate v, List lines) {
        for (int i = 0; i < lines.size(); ++i) {
            LineString line = (LineString)lines.get(i);
            for (int j = 0; j < line.getNumPoints() - 1; ++j) {
                Coordinate p1;
                Coordinate p0 = line.getCoordinateN(j);
                if (this.isSnapped(v, p0, p1 = line.getCoordinateN(j + 1))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSnapped(Coordinate v, Coordinate p0, Coordinate p1) {
        if (v.equals2D(p0)) {
            return true;
        }
        if (v.equals2D(p1)) {
            return true;
        }
        LineSegment seg = new LineSegment(p0, p1);
        double dist = seg.distance(v);
        return !(dist < 0.48780487804878053);
    }
}

