/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;

public class LinearLocationTest
extends TestCase {
    private WKTReader reader = new WKTReader();

    public static void main(String[] args) {
        TestRunner.run(LinearLocationTest.class);
    }

    public LinearLocationTest(String name) {
        super(name);
    }

    public void testZeroLengthLineString() throws Exception {
        Geometry line = this.reader.read("LINESTRING (10 0, 10 0)");
        LocationIndexedLine indexedLine = new LocationIndexedLine(line);
        LinearLocation loc0 = indexedLine.indexOf(new Coordinate(11.0, 0.0));
        LinearLocationTest.assertTrue((loc0.compareTo(new LinearLocation(1, 0.0)) == 0 ? 1 : 0) != 0);
    }

    public void testRepeatedCoordsLineString() throws Exception {
        Geometry line = this.reader.read("LINESTRING (10 0, 10 0, 20 0)");
        LocationIndexedLine indexedLine = new LocationIndexedLine(line);
        LinearLocation loc0 = indexedLine.indexOf(new Coordinate(11.0, 0.0));
        LinearLocationTest.assertTrue((loc0.compareTo(new LinearLocation(1, 0.1)) == 0 ? 1 : 0) != 0);
    }

    public void testEndLocation() throws Exception {
        Geometry line = this.reader.read("LINESTRING (10 0, 20 0)");
        LinearLocation loc0 = LinearLocation.getEndLocation(line);
        LinearLocationTest.assertTrue((0.0 == loc0.getSegmentFraction() ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((1 == loc0.getSegmentIndex() ? 1 : 0) != 0);
        LocationIndexedLine indexedLine = new LocationIndexedLine(line);
        LinearLocation endLoc = indexedLine.getEndIndex();
        LinearLocation normLoc = new LinearLocation(endLoc.getComponentIndex(), endLoc.getSegmentIndex(), endLoc.getSegmentFraction());
        LinearLocationTest.assertTrue((normLoc.getComponentIndex() == endLoc.getComponentIndex() ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((normLoc.getSegmentIndex() == endLoc.getSegmentIndex() ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((normLoc.getSegmentFraction() == endLoc.getSegmentFraction() ? 1 : 0) != 0);
    }

    public void testIsEndPoint() throws Exception {
        Geometry line = this.reader.read("LINESTRING (10 0, 20 0)");
        LinearLocationTest.assertTrue((!new LinearLocation(0, 0.0).isEndpoint(line) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((!new LinearLocation(0, 0.5).isEndpoint(line) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((!new LinearLocation(0, 0.9999).isEndpoint(line) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((boolean)new LinearLocation(0, 1.0).isEndpoint(line));
        LinearLocationTest.assertTrue((boolean)new LinearLocation(1, 0.0).isEndpoint(line));
        LinearLocationTest.assertTrue((boolean)new LinearLocation(1, 0.5).isEndpoint(line));
        LinearLocationTest.assertTrue((boolean)new LinearLocation(1, 1.0).isEndpoint(line));
        LinearLocationTest.assertTrue((boolean)new LinearLocation(1, 1.5).isEndpoint(line));
        LinearLocationTest.assertTrue((boolean)new LinearLocation(2, 0.5).isEndpoint(line));
        LinearLocation loc = new LinearLocation(0, 0.0);
        loc.setToEnd(line);
        LinearLocationTest.assertTrue((boolean)loc.isEndpoint(line));
        LinearLocation locLow = loc.toLowest(line);
        LinearLocationTest.assertTrue((boolean)locLow.isEndpoint(line));
    }

    public void testEndPointLowest() throws Exception {
        Geometry line = this.reader.read("LINESTRING (10 0, 20 0, 30 10)");
        LinearLocationTest.assertTrue((boolean)new LinearLocation(1, 1.0).isEndpoint(line));
        LinearLocationTest.assertTrue((boolean)new LinearLocation(2, 0.0).isEndpoint(line));
        LinearLocationTest.assertTrue((boolean)new LinearLocation(2, 0.5).isEndpoint(line));
        LinearLocation loc = new LinearLocation(0, 0.0);
        loc.setToEnd(line);
        LinearLocationTest.assertTrue((boolean)loc.isEndpoint(line));
        LinearLocationTest.assertEquals((int)2, (int)loc.getSegmentIndex());
        LinearLocationTest.assertEquals((Object)0.0, (Object)loc.getSegmentFraction());
        LinearLocation locLow = loc.toLowest(line);
        LinearLocationTest.assertTrue((boolean)locLow.isEndpoint(line));
        LinearLocationTest.assertEquals((int)1, (int)locLow.getSegmentIndex());
        LinearLocationTest.assertEquals((Object)1.0, (Object)locLow.getSegmentFraction());
    }

    public void testSameSegmentLineString() throws Exception {
        Geometry line = this.reader.read("LINESTRING (0 0, 10 0, 20 0, 30 0)");
        LocationIndexedLine indexedLine = new LocationIndexedLine(line);
        LinearLocation loc0 = indexedLine.indexOf(new Coordinate(0.0, 0.0));
        LinearLocation loc0_5 = indexedLine.indexOf(new Coordinate(5.0, 0.0));
        LinearLocation loc1 = indexedLine.indexOf(new Coordinate(10.0, 0.0));
        LinearLocation loc2 = indexedLine.indexOf(new Coordinate(20.0, 0.0));
        LinearLocation loc2_5 = indexedLine.indexOf(new Coordinate(25.0, 0.0));
        LinearLocation loc3 = indexedLine.indexOf(new Coordinate(30.0, 0.0));
        LinearLocationTest.assertTrue((boolean)loc0.isOnSameSegment(loc0));
        LinearLocationTest.assertTrue((boolean)loc0.isOnSameSegment(loc0_5));
        LinearLocationTest.assertTrue((boolean)loc0.isOnSameSegment(loc1));
        LinearLocationTest.assertTrue((!loc0.isOnSameSegment(loc2) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((!loc0.isOnSameSegment(loc2_5) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((!loc0.isOnSameSegment(loc3) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((boolean)loc0_5.isOnSameSegment(loc0));
        LinearLocationTest.assertTrue((boolean)loc0_5.isOnSameSegment(loc1));
        LinearLocationTest.assertTrue((!loc0_5.isOnSameSegment(loc2) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((!loc0_5.isOnSameSegment(loc3) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((!loc2.isOnSameSegment(loc0) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((boolean)loc2.isOnSameSegment(loc1));
        LinearLocationTest.assertTrue((boolean)loc2.isOnSameSegment(loc2));
        LinearLocationTest.assertTrue((boolean)loc2.isOnSameSegment(loc3));
        LinearLocationTest.assertTrue((boolean)loc2_5.isOnSameSegment(loc3));
        LinearLocationTest.assertTrue((!loc3.isOnSameSegment(loc0) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((boolean)loc3.isOnSameSegment(loc2));
        LinearLocationTest.assertTrue((boolean)loc3.isOnSameSegment(loc2_5));
        LinearLocationTest.assertTrue((boolean)loc3.isOnSameSegment(loc3));
    }

    public void testSameSegmentMultiLineString() throws Exception {
        Geometry line = this.reader.read("MULTILINESTRING ((0 0, 10 0, 20 0), (20 0, 30 0))");
        LocationIndexedLine indexedLine = new LocationIndexedLine(line);
        LinearLocation loc0 = indexedLine.indexOf(new Coordinate(0.0, 0.0));
        LinearLocation loc0_5 = indexedLine.indexOf(new Coordinate(5.0, 0.0));
        LinearLocation loc1 = indexedLine.indexOf(new Coordinate(10.0, 0.0));
        LinearLocation loc2 = indexedLine.indexOf(new Coordinate(20.0, 0.0));
        LinearLocation loc2B = new LinearLocation(1, 0, 0.0);
        LinearLocation loc2_5 = indexedLine.indexOf(new Coordinate(25.0, 0.0));
        LinearLocation loc3 = indexedLine.indexOf(new Coordinate(30.0, 0.0));
        LinearLocationTest.assertTrue((boolean)loc0.isOnSameSegment(loc0));
        LinearLocationTest.assertTrue((boolean)loc0.isOnSameSegment(loc0_5));
        LinearLocationTest.assertTrue((boolean)loc0.isOnSameSegment(loc1));
        LinearLocationTest.assertTrue((!loc0.isOnSameSegment(loc2) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((!loc0.isOnSameSegment(loc2_5) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((!loc0.isOnSameSegment(loc3) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((boolean)loc0_5.isOnSameSegment(loc0));
        LinearLocationTest.assertTrue((boolean)loc0_5.isOnSameSegment(loc1));
        LinearLocationTest.assertTrue((!loc0_5.isOnSameSegment(loc2) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((!loc0_5.isOnSameSegment(loc3) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((!loc2.isOnSameSegment(loc0) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((boolean)loc2.isOnSameSegment(loc1));
        LinearLocationTest.assertTrue((boolean)loc2.isOnSameSegment(loc2));
        LinearLocationTest.assertTrue((!loc2.isOnSameSegment(loc3) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((boolean)loc2B.isOnSameSegment(loc3));
        LinearLocationTest.assertTrue((boolean)loc2_5.isOnSameSegment(loc3));
        LinearLocationTest.assertTrue((!loc3.isOnSameSegment(loc0) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((!loc3.isOnSameSegment(loc2) ? 1 : 0) != 0);
        LinearLocationTest.assertTrue((boolean)loc3.isOnSameSegment(loc2B));
        LinearLocationTest.assertTrue((boolean)loc3.isOnSameSegment(loc2_5));
        LinearLocationTest.assertTrue((boolean)loc3.isOnSameSegment(loc3));
    }

    public void testGetSegmentMultiLineString() throws Exception {
        Geometry line = this.reader.read("MULTILINESTRING ((0 0, 10 0, 20 0), (20 0, 30 0))");
        LocationIndexedLine indexedLine = new LocationIndexedLine(line);
        LinearLocation loc0 = indexedLine.indexOf(new Coordinate(0.0, 0.0));
        LinearLocation loc0_5 = indexedLine.indexOf(new Coordinate(5.0, 0.0));
        LinearLocation loc1 = indexedLine.indexOf(new Coordinate(10.0, 0.0));
        LinearLocation loc2 = indexedLine.indexOf(new Coordinate(20.0, 0.0));
        LinearLocation loc2B = new LinearLocation(1, 0, 0.0);
        LinearLocation loc2_5 = indexedLine.indexOf(new Coordinate(25.0, 0.0));
        LinearLocation loc3 = indexedLine.indexOf(new Coordinate(30.0, 0.0));
        LineSegment seg0 = new LineSegment(new Coordinate(0.0, 0.0), new Coordinate(10.0, 0.0));
        LineSegment seg1 = new LineSegment(new Coordinate(10.0, 0.0), new Coordinate(20.0, 0.0));
        LineSegment seg2 = new LineSegment(new Coordinate(20.0, 0.0), new Coordinate(30.0, 0.0));
        LinearLocationTest.assertTrue((boolean)loc0.getSegment(line).equals(seg0));
        LinearLocationTest.assertTrue((boolean)loc0_5.getSegment(line).equals(seg0));
        LinearLocationTest.assertTrue((boolean)loc1.getSegment(line).equals(seg1));
        LinearLocationTest.assertTrue((boolean)loc2.getSegment(line).equals(seg1));
        LinearLocationTest.assertTrue((boolean)loc2_5.getSegment(line).equals(seg2));
        LinearLocationTest.assertTrue((boolean)loc3.getSegment(line).equals(seg2));
    }
}

