/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.index.strtree.Interval;

public class IntervalTest
extends TestCase {
    public IntervalTest(String Name_) {
        super(Name_);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{IntervalTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public void testIntersectsBasic() {
        IntervalTest.assertTrue((boolean)new Interval(5.0, 10.0).intersects(new Interval(7.0, 12.0)));
        IntervalTest.assertTrue((boolean)new Interval(7.0, 12.0).intersects(new Interval(5.0, 10.0)));
        IntervalTest.assertTrue((!new Interval(5.0, 10.0).intersects(new Interval(11.0, 12.0)) ? 1 : 0) != 0);
        IntervalTest.assertTrue((!new Interval(11.0, 12.0).intersects(new Interval(5.0, 10.0)) ? 1 : 0) != 0);
        IntervalTest.assertTrue((boolean)new Interval(5.0, 10.0).intersects(new Interval(10.0, 12.0)));
        IntervalTest.assertTrue((boolean)new Interval(10.0, 12.0).intersects(new Interval(5.0, 10.0)));
    }

    public void testIntersectsZeroWidthInterval() {
        IntervalTest.assertTrue((boolean)new Interval(10.0, 10.0).intersects(new Interval(7.0, 12.0)));
        IntervalTest.assertTrue((boolean)new Interval(7.0, 12.0).intersects(new Interval(10.0, 10.0)));
        IntervalTest.assertTrue((!new Interval(10.0, 10.0).intersects(new Interval(11.0, 12.0)) ? 1 : 0) != 0);
        IntervalTest.assertTrue((!new Interval(11.0, 12.0).intersects(new Interval(10.0, 10.0)) ? 1 : 0) != 0);
        IntervalTest.assertTrue((boolean)new Interval(10.0, 10.0).intersects(new Interval(10.0, 12.0)));
        IntervalTest.assertTrue((boolean)new Interval(10.0, 12.0).intersects(new Interval(10.0, 10.0)));
    }

    public void testCopyConstructor() {
        IntervalTest.assertEquals((Object)new Interval(3.0, 4.0), (Object)new Interval(3.0, 4.0));
        IntervalTest.assertEquals((Object)new Interval(3.0, 4.0), (Object)new Interval(new Interval(3.0, 4.0)));
    }

    public void testGetCentre() {
        IntervalTest.assertEquals((double)6.5, (double)new Interval(4.0, 9.0).getCentre(), (double)1.0E-10);
    }

    public void testExpandToInclude() {
        IntervalTest.assertEquals((Object)new Interval(3.0, 8.0), (Object)new Interval(3.0, 4.0).expandToInclude(new Interval(7.0, 8.0)));
        IntervalTest.assertEquals((Object)new Interval(3.0, 7.0), (Object)new Interval(3.0, 7.0).expandToInclude(new Interval(4.0, 5.0)));
        IntervalTest.assertEquals((Object)new Interval(3.0, 8.0), (Object)new Interval(3.0, 7.0).expandToInclude(new Interval(4.0, 8.0)));
    }
}

