/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.geom.util.SineStarFactory;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.util.GeometricShapeFactory;

public class PreparedPolygonIntersectsStressTest
extends TestCase {
    static final int MAX_ITER = 10000;
    static PrecisionModel pm = new PrecisionModel();
    static GeometryFactory fact = new GeometryFactory(pm, 0);
    static WKTReader wktRdr = new WKTReader(fact);
    static WKTWriter wktWriter = new WKTWriter();
    boolean testFailed = false;

    public static void main(String[] args) {
        TestRunner.run(PreparedPolygonIntersectsStressTest.class);
    }

    public PreparedPolygonIntersectsStressTest(String name) {
        super(name);
    }

    public void test() {
        this.run(1000);
    }

    public void run(int nPts) {
        Geometry poly = this.createSineStar(new Coordinate(0.0, 0.0), 100.0, nPts);
        this.test(poly);
    }

    Geometry createCircle(Coordinate origin, double size, int nPts) {
        GeometricShapeFactory gsf = new GeometricShapeFactory();
        gsf.setCentre(origin);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        Polygon circle = gsf.createCircle();
        return circle;
    }

    Geometry createSineStar(Coordinate origin, double size, int nPts) {
        SineStarFactory gsf = new SineStarFactory();
        gsf.setCentre(origin);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        gsf.setArmLengthRatio(0.1);
        gsf.setNumArms(20);
        Geometry poly = gsf.createSineStar();
        return poly;
    }

    LineString createTestLine(Envelope env, double size, int nPts) {
        double width = env.getWidth();
        double xOffset = width * Math.random();
        double yOffset = env.getHeight() * Math.random();
        Coordinate basePt = new Coordinate(env.getMinX() + xOffset, env.getMinY() + yOffset);
        LineString line = this.createTestLine(basePt, size, nPts);
        return line;
    }

    LineString createTestLine(Coordinate base, double size, int nPts) {
        GeometricShapeFactory gsf = new GeometricShapeFactory();
        gsf.setCentre(base);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        Polygon circle = gsf.createCircle();
        return (LineString)((Geometry)circle).getBoundary();
    }

    public void test(Geometry g) {
        for (int count = 0; count < 10000; ++count) {
            LineString line = this.createTestLine(g.getEnvelopeInternal(), 10.0, 20);
            this.testResultsEqual(g, line);
        }
    }

    public void testResultsEqual(Geometry g, LineString line) {
        PreparedGeometryFactory pgFact;
        PreparedGeometry prepGeom;
        boolean fastIntersects;
        boolean slowIntersects = g.intersects(line);
        if (slowIntersects != (fastIntersects = (prepGeom = (pgFact = new PreparedGeometryFactory()).create(g)).intersects(line))) {
            System.out.println(line);
            System.out.println("Slow = " + slowIntersects + ", Fast = " + fastIntersects);
            throw new RuntimeException("Different results found for intersects() !");
        }
    }
}

