/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.Random;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.io.WKTReader;

public class CoordinateSequencesTest
extends TestCase {
    private PrecisionModel precisionModel = new PrecisionModel();
    private GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);
    private static final double[][] ordinateValues = new double[][]{{75.76, 77.43}, {41.35, 90.75}, {73.74, 41.67}, {20.87, 86.49}, {17.49, 93.59}, {67.75, 80.63}, {63.01, 52.57}, {32.9, 44.44}, {79.36, 29.8}, {38.17, 88.0}, {19.31, 49.71}, {57.03, 19.28}, {63.76, 77.35}, {45.26, 85.15}, {51.71, 50.38}, {92.16, 19.85}, {64.18, 27.7}, {64.74, 65.1}, {80.07, 13.55}, {55.54, 94.07}};

    public static void main(String[] args) {
        TestRunner.run(CoordinateSequencesTest.class);
    }

    public CoordinateSequencesTest(String name) {
        super(name);
    }

    public void testCopyToLargerDim() {
        PackedCoordinateSequenceFactory csFactory = new PackedCoordinateSequenceFactory();
        CoordinateSequence cs2D = CoordinateSequencesTest.createTestSequence(csFactory, 10, 2);
        CoordinateSequence cs3D = csFactory.create(10, 3);
        CoordinateSequences.copy(cs2D, 0, cs3D, 0, cs3D.size());
        CoordinateSequencesTest.assertTrue((boolean)CoordinateSequences.isEqual(cs2D, cs3D));
    }

    public void testCopyToSmallerDim() {
        PackedCoordinateSequenceFactory csFactory = new PackedCoordinateSequenceFactory();
        CoordinateSequence cs3D = CoordinateSequencesTest.createTestSequence(csFactory, 10, 3);
        CoordinateSequence cs2D = csFactory.create(10, 2);
        CoordinateSequences.copy(cs3D, 0, cs2D, 0, cs2D.size());
        CoordinateSequencesTest.assertTrue((boolean)CoordinateSequences.isEqual(cs2D, cs3D));
    }

    public void testScrollRing() {
        System.out.println("Testing scrolling of closed ring");
        CoordinateSequencesTest.doTestScrollRing(CoordinateArraySequenceFactory.instance(), 2);
        CoordinateSequencesTest.doTestScrollRing(CoordinateArraySequenceFactory.instance(), 3);
        CoordinateSequencesTest.doTestScrollRing(PackedCoordinateSequenceFactory.DOUBLE_FACTORY, 2);
        CoordinateSequencesTest.doTestScrollRing(PackedCoordinateSequenceFactory.DOUBLE_FACTORY, 4);
        CoordinateSequencesTest.doTestScrollRing(PackedCoordinateSequenceFactory.FLOAT_FACTORY, 2);
        CoordinateSequencesTest.doTestScrollRing(PackedCoordinateSequenceFactory.FLOAT_FACTORY, 4);
    }

    public void testScroll() {
        System.out.println("Testing scrolling of circular string");
        CoordinateSequencesTest.doTestScroll(CoordinateArraySequenceFactory.instance(), 2);
        CoordinateSequencesTest.doTestScroll(CoordinateArraySequenceFactory.instance(), 3);
        CoordinateSequencesTest.doTestScroll(PackedCoordinateSequenceFactory.DOUBLE_FACTORY, 2);
        CoordinateSequencesTest.doTestScroll(PackedCoordinateSequenceFactory.DOUBLE_FACTORY, 4);
        CoordinateSequencesTest.doTestScroll(PackedCoordinateSequenceFactory.FLOAT_FACTORY, 2);
        CoordinateSequencesTest.doTestScroll(PackedCoordinateSequenceFactory.FLOAT_FACTORY, 4);
    }

    public void testIndexOf() {
        System.out.println("Testing indexOf");
        CoordinateSequencesTest.doTestIndexOf(CoordinateArraySequenceFactory.instance(), 2);
        CoordinateSequencesTest.doTestIndexOf(PackedCoordinateSequenceFactory.DOUBLE_FACTORY, 5);
        CoordinateSequencesTest.doTestIndexOf(PackedCoordinateSequenceFactory.FLOAT_FACTORY, 7);
    }

    public void testMinCoordinateIndex() {
        System.out.println("Testing minCoordinateIndex");
        CoordinateSequencesTest.doTestMinCoordinateIndex(CoordinateArraySequenceFactory.instance(), 2);
        CoordinateSequencesTest.doTestMinCoordinateIndex(PackedCoordinateSequenceFactory.DOUBLE_FACTORY, 5);
        CoordinateSequencesTest.doTestMinCoordinateIndex(PackedCoordinateSequenceFactory.FLOAT_FACTORY, 7);
    }

    public void testIsRing() {
        System.out.println("Testing isRing");
        CoordinateSequencesTest.doTestIsRing(CoordinateArraySequenceFactory.instance(), 2);
        CoordinateSequencesTest.doTestIsRing(PackedCoordinateSequenceFactory.DOUBLE_FACTORY, 5);
        CoordinateSequencesTest.doTestIsRing(PackedCoordinateSequenceFactory.FLOAT_FACTORY, 7);
    }

    public void testCopy() {
        System.out.println("Testing copy");
        CoordinateSequencesTest.doTestCopy(CoordinateArraySequenceFactory.instance(), 2);
        CoordinateSequencesTest.doTestCopy(PackedCoordinateSequenceFactory.DOUBLE_FACTORY, 5);
        CoordinateSequencesTest.doTestCopy(PackedCoordinateSequenceFactory.FLOAT_FACTORY, 7);
    }

    public void testReverse() {
        System.out.println("Testing reverse");
        CoordinateSequencesTest.doTestReverse(CoordinateArraySequenceFactory.instance(), 2);
        CoordinateSequencesTest.doTestReverse(PackedCoordinateSequenceFactory.DOUBLE_FACTORY, 5);
        CoordinateSequencesTest.doTestReverse(PackedCoordinateSequenceFactory.FLOAT_FACTORY, 7);
    }

    public void ttestCreateRandomOrdinates() {
        CoordinateSequence sequence = CoordinateSequencesTest.createRandomTestSequence(CoordinateArraySequenceFactory.instance(), 20, 2, new Random(7L), new Envelope(10.0, 100.0, 10.0, 100.0), new PrecisionModel(100.0));
        StringBuilder ordinates = new StringBuilder("\tprivate static final double[][] ordinateValues = {");
        for (int i = 0; i < sequence.size(); ++i) {
            if (i % 6 == 0) {
                ordinates.append("\n\t\t");
            }
            ordinates.append('{');
            ordinates.append(sequence.getOrdinate(i, 0));
            ordinates.append(',');
            ordinates.append(sequence.getOrdinate(i, 1));
            if (i < sequence.size() - 1) {
                ordinates.append("},");
                continue;
            }
            ordinates.append('}');
        }
        ordinates.append("};");
        System.out.println(ordinates.toString());
        CoordinateSequencesTest.assertTrue((boolean)true);
    }

    private static CoordinateSequence createSequenceFromOrdinates(CoordinateSequenceFactory csFactory, int dim) {
        CoordinateSequence sequence = csFactory.create(ordinateValues.length, dim);
        for (int i = 0; i < ordinateValues.length; ++i) {
            sequence.setOrdinate(i, 0, ordinateValues[i][0]);
            sequence.setOrdinate(i, 1, ordinateValues[i][1]);
        }
        return CoordinateSequencesTest.fillNonPlanarDimensions(sequence);
    }

    private static CoordinateSequence createTestSequence(CoordinateSequenceFactory csFactory, int size, int dim) {
        CoordinateSequence cs = csFactory.create(size, dim);
        for (int i = 0; i < size; ++i) {
            for (int d = 0; d < dim; ++d) {
                cs.setOrdinate(i, d, (double)i * Math.pow(10.0, d));
            }
        }
        return cs;
    }

    private static CoordinateSequence createRandomTestSequence(CoordinateSequenceFactory csFactory, int size, int dim, Random rnd, Envelope range, PrecisionModel pm) {
        CoordinateSequence cs = csFactory.create(size, dim);
        for (int i = 0; i < size; ++i) {
            cs.setOrdinate(i, 0, pm.makePrecise(range.getWidth() * rnd.nextDouble() + range.getMinX()));
            cs.setOrdinate(i, 1, pm.makePrecise(range.getHeight() * rnd.nextDouble() + range.getMinY()));
        }
        return CoordinateSequencesTest.fillNonPlanarDimensions(cs);
    }

    private static void doTestReverse(CoordinateSequenceFactory factory, int dimension) {
        CoordinateSequence sequence = CoordinateSequencesTest.createSequenceFromOrdinates(factory, dimension);
        CoordinateSequence reversed = sequence.copy();
        CoordinateSequences.reverse(reversed);
        for (int i = 0; i < sequence.size(); ++i) {
            CoordinateSequencesTest.checkCoordinateAt(sequence, i, reversed, sequence.size() - i - 1, dimension);
        }
    }

    private static void doTestCopy(CoordinateSequenceFactory factory, int dimension) {
        int i;
        CoordinateSequence sequence = CoordinateSequencesTest.createSequenceFromOrdinates(factory, dimension);
        if (sequence.size() <= 7) {
            System.out.println("sequence has a size of " + sequence.size() + ". Execution of this test needs a sequence with more than 6 coordinates.");
            return;
        }
        CoordinateSequence fullCopy = factory.create(sequence.size(), dimension);
        CoordinateSequence partialCopy = factory.create(sequence.size() - 5, dimension);
        CoordinateSequences.copy(sequence, 0, fullCopy, 0, sequence.size());
        CoordinateSequences.copy(sequence, 2, partialCopy, 0, partialCopy.size());
        for (i = 0; i < fullCopy.size(); ++i) {
            CoordinateSequencesTest.checkCoordinateAt(sequence, i, fullCopy, i, dimension);
        }
        for (i = 0; i < partialCopy.size(); ++i) {
            CoordinateSequencesTest.checkCoordinateAt(sequence, 2 + i, partialCopy, i, dimension);
        }
    }

    private static void doTestIsRing(CoordinateSequenceFactory factory, int dimension) {
        CoordinateSequence ring = CoordinateSequencesTest.createCircle(factory, dimension, new Coordinate(), 5.0);
        CoordinateSequence noRing = CoordinateSequencesTest.createCircularString(factory, dimension, new Coordinate(), 5.0, 0.1, 22);
        CoordinateSequence empty = CoordinateSequencesTest.createAlmostRing(factory, dimension, 0);
        CoordinateSequence incomplete1 = CoordinateSequencesTest.createAlmostRing(factory, dimension, 1);
        CoordinateSequence incomplete2 = CoordinateSequencesTest.createAlmostRing(factory, dimension, 2);
        CoordinateSequence incomplete3 = CoordinateSequencesTest.createAlmostRing(factory, dimension, 3);
        CoordinateSequence incomplete4a = CoordinateSequencesTest.createAlmostRing(factory, dimension, 4);
        CoordinateSequence incomplete4b = CoordinateSequences.ensureValidRing(factory, incomplete4a);
        boolean isRingRing = CoordinateSequences.isRing(ring);
        boolean isRingNoRing = CoordinateSequences.isRing(noRing);
        boolean isRingEmpty = CoordinateSequences.isRing(empty);
        boolean isRingIncomplete1 = CoordinateSequences.isRing(incomplete1);
        boolean isRingIncomplete2 = CoordinateSequences.isRing(incomplete2);
        boolean isRingIncomplete3 = CoordinateSequences.isRing(incomplete3);
        boolean isRingIncomplete4a = CoordinateSequences.isRing(incomplete4a);
        boolean isRingIncomplete4b = CoordinateSequences.isRing(incomplete4b);
        CoordinateSequencesTest.assertTrue((boolean)isRingRing);
        CoordinateSequencesTest.assertTrue((!isRingNoRing ? 1 : 0) != 0);
        CoordinateSequencesTest.assertTrue((boolean)isRingEmpty);
        CoordinateSequencesTest.assertTrue((!isRingIncomplete1 ? 1 : 0) != 0);
        CoordinateSequencesTest.assertTrue((!isRingIncomplete2 ? 1 : 0) != 0);
        CoordinateSequencesTest.assertTrue((!isRingIncomplete3 ? 1 : 0) != 0);
        CoordinateSequencesTest.assertTrue((!isRingIncomplete4a ? 1 : 0) != 0);
        CoordinateSequencesTest.assertTrue((boolean)isRingIncomplete4b);
    }

    private static void doTestIndexOf(CoordinateSequenceFactory factory, int dimension) {
        CoordinateSequence sequence = CoordinateSequencesTest.createSequenceFromOrdinates(factory, dimension);
        Coordinate[] coordinates = sequence.toCoordinateArray();
        for (int i = 0; i < sequence.size(); ++i) {
            CoordinateSequencesTest.assertEquals((int)i, (int)CoordinateSequences.indexOf(coordinates[i], sequence));
        }
    }

    private static void doTestMinCoordinateIndex(CoordinateSequenceFactory factory, int dimension) {
        CoordinateSequence sequence = CoordinateSequencesTest.createSequenceFromOrdinates(factory, dimension);
        if (sequence.size() <= 6) {
            System.out.println("sequence has a size of " + sequence.size() + ". Execution of this test needs a sequence with more than 5 coordinates.");
            return;
        }
        int minIndex = sequence.size() / 2;
        sequence.setOrdinate(minIndex, 0, 5.0);
        sequence.setOrdinate(minIndex, 1, 5.0);
        CoordinateSequencesTest.assertEquals((int)minIndex, (int)CoordinateSequences.minCoordinateIndex(sequence));
        CoordinateSequencesTest.assertEquals((int)minIndex, (int)CoordinateSequences.minCoordinateIndex(sequence, 2, sequence.size() - 2));
    }

    private static void doTestScroll(CoordinateSequenceFactory factory, int dimension) {
        CoordinateSequence sequence = CoordinateSequencesTest.createCircularString(factory, dimension, new Coordinate(20.0, 20.0), 7.0, 0.1, 22);
        CoordinateSequence scrolled = sequence.copy();
        CoordinateSequences.scroll(scrolled, 12);
        int io = 12;
        for (int is = 0; is < scrolled.size() - 1; ++is) {
            CoordinateSequencesTest.checkCoordinateAt(sequence, io, scrolled, is, dimension);
            ++io;
            io %= scrolled.size();
        }
    }

    private static void doTestScrollRing(CoordinateSequenceFactory factory, int dimension) {
        CoordinateSequence sequence = CoordinateSequencesTest.createCircle(factory, dimension, new Coordinate(10.0, 10.0), 9.0);
        CoordinateSequence scrolled = sequence.copy();
        CoordinateSequences.scroll(scrolled, 12);
        int io = 12;
        for (int is = 0; is < scrolled.size() - 1; ++is) {
            CoordinateSequencesTest.checkCoordinateAt(sequence, io, scrolled, is, dimension);
            ++io;
            io %= scrolled.size() - 1;
        }
        CoordinateSequencesTest.checkCoordinateAt(scrolled, 0, scrolled, scrolled.size() - 1, dimension);
    }

    private static void checkCoordinateAt(CoordinateSequence seq1, int pos1, CoordinateSequence seq2, int pos2, int dim) {
        CoordinateSequencesTest.assertEquals((String)("unexpected x-ordinate at pos " + pos2), (Object)seq1.getOrdinate(pos1, 0), (Object)seq2.getOrdinate(pos2, 0));
        CoordinateSequencesTest.assertEquals((String)("unexpected y-ordinate at pos " + pos2), (Object)seq1.getOrdinate(pos1, 1), (Object)seq2.getOrdinate(pos2, 1));
        for (int j = 2; j < dim; ++j) {
            CoordinateSequencesTest.assertEquals((String)("unexpected " + j + "-ordinate at pos " + pos2), (Object)seq1.getOrdinate(pos1, j), (Object)seq2.getOrdinate(pos2, j));
        }
    }

    private static CoordinateSequence createAlmostRing(CoordinateSequenceFactory factory, int dimension, int num) {
        if (num > 4) {
            num = 4;
        }
        CoordinateSequence sequence = factory.create(num, dimension);
        if (num == 0) {
            return CoordinateSequencesTest.fillNonPlanarDimensions(sequence);
        }
        sequence.setOrdinate(0, 0, 10.0);
        sequence.setOrdinate(0, 0, 10.0);
        if (num == 1) {
            return CoordinateSequencesTest.fillNonPlanarDimensions(sequence);
        }
        sequence.setOrdinate(0, 0, 20.0);
        sequence.setOrdinate(0, 0, 10.0);
        if (num == 2) {
            return CoordinateSequencesTest.fillNonPlanarDimensions(sequence);
        }
        sequence.setOrdinate(0, 0, 20.0);
        sequence.setOrdinate(0, 0, 20.0);
        if (num == 3) {
            return CoordinateSequencesTest.fillNonPlanarDimensions(sequence);
        }
        sequence.setOrdinate(0, 0, 10.0000000000001);
        sequence.setOrdinate(0, 0, 9.9999999999999);
        return CoordinateSequencesTest.fillNonPlanarDimensions(sequence);
    }

    private static CoordinateSequence fillNonPlanarDimensions(CoordinateSequence seq) {
        if (seq.getDimension() < 3) {
            return seq;
        }
        for (int i = 0; i < seq.size(); ++i) {
            for (int j = 2; j < seq.getDimension(); ++j) {
                seq.setOrdinate(i, j, (double)i * Math.pow(10.0, j - 1));
            }
        }
        return seq;
    }

    private static CoordinateSequence createCircle(CoordinateSequenceFactory factory, int dimension, Coordinate center, double radius) {
        CoordinateSequence res = CoordinateSequencesTest.createCircularString(factory, dimension, center, radius, 0.0, 49);
        for (int i = 0; i < dimension; ++i) {
            res.setOrdinate(48, i, res.getOrdinate(0, i));
        }
        return res;
    }

    private static CoordinateSequence createCircularString(CoordinateSequenceFactory factory, int dimension, Coordinate center, double radius, double startAngle, int numPoints) {
        int numSegmentsCircle = 48;
        double angleCircle = Math.PI * 2;
        double angleStep = 0.1308996938995747;
        CoordinateSequence sequence = factory.create(numPoints, dimension);
        PrecisionModel pm = new PrecisionModel(100.0);
        double angle = startAngle;
        for (int i = 0; i < numPoints; ++i) {
            double dx = Math.cos(angle) * radius;
            sequence.setOrdinate(i, 0, pm.makePrecise(center.x + dx));
            double dy = Math.sin(angle) * radius;
            sequence.setOrdinate(i, 1, pm.makePrecise(center.y + dy));
            for (int j = 2; j < dimension; ++j) {
                sequence.setOrdinate(i, j, Math.pow(10.0, j - 1) * (double)i);
            }
            angle += 0.1308996938995747;
            angle %= Math.PI * 2;
        }
        return sequence;
    }
}

