/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.PrjFileReader;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.files.FileReader;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.referencing.FactoryException;

class ShapefileSetManager
implements FileReader {
    private static final Logger LOGGER = Logging.getLogger(ShapefileSetManager.class);
    ShpFiles shpFiles;
    ShapefileDataStore store;

    public ShapefileSetManager(ShpFiles shpFiles, ShapefileDataStore store) {
        this.shpFiles = shpFiles;
        this.store = store;
    }

    protected ShapefileReader openShapeReader(GeometryFactory gf, boolean onlyRandomAccess) throws IOException {
        try {
            return new ShapefileReader(this.shpFiles, true, this.store.isMemoryMapped(), gf, onlyRandomAccess);
        }
        catch (ShapefileException se) {
            throw new DataSourceException("Error creating ShapefileReader", se);
        }
    }

    protected DbaseFileReader openDbfReader(boolean indexed) throws IOException {
        if (this.shpFiles.get(ShpFileType.DBF) == null) {
            return null;
        }
        if (this.shpFiles.isLocal() && !this.shpFiles.exists(ShpFileType.DBF)) {
            return null;
        }
        Charset charset = this.store.getCharset();
        if (this.store.isTryCPGFile() && this.shpFiles.get(ShpFileType.CPG) != null && (!this.shpFiles.isLocal() || this.shpFiles.isLocal() && this.shpFiles.exists(ShpFileType.CPG))) {
            try (BufferedReader br2 = new BufferedReader(new InputStreamReader(this.shpFiles.getInputStream(ShpFileType.CPG, this), StandardCharsets.ISO_8859_1));){
                String charsetName = br2.readLine();
                if (charsetName != null) {
                    try {
                        charset = Charset.forName(charsetName.trim());
                        this.store.setCharset(charset);
                    }
                    catch (Exception e) {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("Can't figure out charset from CPG file. Will use provided by the store.");
                        }
                    }
                }
            }
            catch (IOException br2) {
                // empty catch block
            }
        }
        try {
            if (indexed) {
                return new IndexedDbaseFileReader(this.shpFiles, this.store.isMemoryMapped(), charset, this.store.getTimeZone());
            }
            return new DbaseFileReader(this.shpFiles, this.store.isMemoryMapped(), charset, this.store.getTimeZone());
        }
        catch (IOException e) {
            return null;
        }
    }

    protected PrjFileReader openPrjReader() throws IOException, FactoryException {
        if (this.shpFiles.get(ShpFileType.PRJ) == null) {
            return null;
        }
        if (this.shpFiles.isLocal() && !this.shpFiles.exists(ShpFileType.PRJ)) {
            return null;
        }
        try {
            return new PrjFileReader(this.shpFiles.getReadChannel(ShpFileType.PRJ, this));
        }
        catch (IOException e) {
            return null;
        }
    }

    protected IndexFile openIndexFile() throws IOException {
        if (this.shpFiles.get(ShpFileType.SHX) == null) {
            return null;
        }
        if (this.shpFiles.isLocal() && !this.shpFiles.exists(ShpFileType.SHX)) {
            return null;
        }
        try {
            return new IndexFile(this.shpFiles, this.store.isMemoryMapped());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String id() {
        return this.getClass().getName();
    }
}

