/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photo_geotagging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.time.Instant;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffImageWriterLossy;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.openstreetmap.josm.tools.I18n;

public class ExifGPSTagger {
    public static void setExifGPSTag(File imageFile, File dst, double lat, double lon, Instant gpsTime, Double speed, Double ele, Double imgDir, boolean lossy) throws IOException {
        try {
            ExifGPSTagger.setExifGPSTagWorker(imageFile, dst, lat, lon, gpsTime, speed, ele, imgDir, lossy);
        }
        catch (ImageReadException ire) {
            throw new IOException(I18n.tr((String)("Read error: " + (Object)((Object)ire)), (Object[])new Object[0]), ire);
        }
        catch (ImageWriteException ire2) {
            throw new IOException(I18n.tr((String)("Write error: " + (Object)((Object)ire2)), (Object[])new Object[0]), ire2);
        }
    }

    public static void setExifGPSTagWorker(File imageFile, File dst, double lat, double lon, Instant gpsTime, Double speed, Double ele, Double imgDir, boolean lossy) throws IOException, ImageReadException, ImageWriteException {
        TiffOutputSet outputSet = null;
        ImageMetadata metadata = Imaging.getMetadata((File)imageFile);
        if (metadata instanceof JpegImageMetadata) {
            TiffImageMetadata exif = ((JpegImageMetadata)metadata).getExif();
            if (null != exif) {
                outputSet = exif.getOutputSet();
            }
        } else if (metadata instanceof TiffImageMetadata) {
            outputSet = ((TiffImageMetadata)metadata).getOutputSet();
        }
        if (null == outputSet) {
            outputSet = new TiffOutputSet();
        }
        TiffOutputDirectory gpsDirectory = outputSet.getOrCreateGPSDirectory();
        gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_VERSION_ID);
        gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_VERSION_ID, new byte[]{2, 3, 0, 0});
        if (gpsTime != null) {
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            calendar.setTimeInMillis(gpsTime.toEpochMilli());
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            DecimalFormat yearFormatter = new DecimalFormat("0000");
            DecimalFormat monthFormatter = new DecimalFormat("00");
            DecimalFormat dayFormatter = new DecimalFormat("00");
            String yearStr = yearFormatter.format(year);
            String monthStr = monthFormatter.format(month);
            String dayStr = dayFormatter.format(day);
            String dateStamp = yearStr + ":" + monthStr + ":" + dayStr;
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_TIME_STAMP);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_TIME_STAMP, new RationalNumber[]{RationalNumber.valueOf((double)hour), RationalNumber.valueOf((double)minute), RationalNumber.valueOf((double)second)});
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_DATE_STAMP);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_DATE_STAMP, new String[]{dateStamp});
        }
        outputSet.setGPSInDegrees(lon, lat);
        if (speed != null) {
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_SPEED_REF);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_SPEED_REF, new String[]{"K"});
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_SPEED);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_SPEED, RationalNumber.valueOf((double)speed));
        }
        if (ele != null) {
            byte eleRef = ele >= 0.0 ? (byte)0 : 1;
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_ALTITUDE_REF);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_ALTITUDE_REF, eleRef);
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_ALTITUDE);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_ALTITUDE, RationalNumber.valueOf((double)Math.abs(ele)));
        }
        if (imgDir != null) {
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION_REF);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION_REF, new String[]{"T"});
            if (imgDir < 0.0) {
                imgDir = imgDir % 360.0;
                imgDir = imgDir + 360.0;
            }
            if (imgDir >= 360.0) {
                imgDir = imgDir % 360.0;
            }
            gpsDirectory.removeField((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION);
            gpsDirectory.add(GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION, RationalNumber.valueOf((double)imgDir));
        }
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dst));){
            if (metadata instanceof JpegImageMetadata) {
                if (lossy) {
                    new ExifRewriter().updateExifMetadataLossy(imageFile, (OutputStream)os, outputSet);
                } else {
                    new ExifRewriter().updateExifMetadataLossless(imageFile, (OutputStream)os, outputSet);
                }
            } else if (metadata instanceof TiffImageMetadata) {
                new TiffImageWriterLossy().write((OutputStream)os, outputSet);
            }
        }
    }
}

