/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class StdVideoH265ScalingLists
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SCALINGLIST4X4;
    public static final int SCALINGLIST8X8;
    public static final int SCALINGLIST16X16;
    public static final int SCALINGLIST32X32;
    public static final int SCALINGLISTDCCOEF16X16;
    public static final int SCALINGLISTDCCOEF32X32;

    public StdVideoH265ScalingLists(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoH265ScalingLists.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_4X4_NUM_ELEMENTS]")
    public ByteBuffer ScalingList4x4() {
        return StdVideoH265ScalingLists.nScalingList4x4(this.address());
    }

    @NativeType(value="uint8_t")
    public byte ScalingList4x4(int index) {
        return StdVideoH265ScalingLists.nScalingList4x4(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_8X8_NUM_ELEMENTS]")
    public ByteBuffer ScalingList8x8() {
        return StdVideoH265ScalingLists.nScalingList8x8(this.address());
    }

    @NativeType(value="uint8_t")
    public byte ScalingList8x8(int index) {
        return StdVideoH265ScalingLists.nScalingList8x8(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_16X16_NUM_ELEMENTS]")
    public ByteBuffer ScalingList16x16() {
        return StdVideoH265ScalingLists.nScalingList16x16(this.address());
    }

    @NativeType(value="uint8_t")
    public byte ScalingList16x16(int index) {
        return StdVideoH265ScalingLists.nScalingList16x16(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_32X32_NUM_ELEMENTS]")
    public ByteBuffer ScalingList32x32() {
        return StdVideoH265ScalingLists.nScalingList32x32(this.address());
    }

    @NativeType(value="uint8_t")
    public byte ScalingList32x32(int index) {
        return StdVideoH265ScalingLists.nScalingList32x32(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_16X16_NUM_LISTS]")
    public ByteBuffer ScalingListDCCoef16x16() {
        return StdVideoH265ScalingLists.nScalingListDCCoef16x16(this.address());
    }

    @NativeType(value="uint8_t")
    public byte ScalingListDCCoef16x16(int index) {
        return StdVideoH265ScalingLists.nScalingListDCCoef16x16(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_32X32_NUM_LISTS]")
    public ByteBuffer ScalingListDCCoef32x32() {
        return StdVideoH265ScalingLists.nScalingListDCCoef32x32(this.address());
    }

    @NativeType(value="uint8_t")
    public byte ScalingListDCCoef32x32(int index) {
        return StdVideoH265ScalingLists.nScalingListDCCoef32x32(this.address(), index);
    }

    public StdVideoH265ScalingLists ScalingList4x4(@NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_4X4_NUM_ELEMENTS]") ByteBuffer value) {
        StdVideoH265ScalingLists.nScalingList4x4(this.address(), value);
        return this;
    }

    public StdVideoH265ScalingLists ScalingList4x4(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoH265ScalingLists.nScalingList4x4(this.address(), index, value);
        return this;
    }

    public StdVideoH265ScalingLists ScalingList8x8(@NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_8X8_NUM_ELEMENTS]") ByteBuffer value) {
        StdVideoH265ScalingLists.nScalingList8x8(this.address(), value);
        return this;
    }

    public StdVideoH265ScalingLists ScalingList8x8(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoH265ScalingLists.nScalingList8x8(this.address(), index, value);
        return this;
    }

    public StdVideoH265ScalingLists ScalingList16x16(@NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_16X16_NUM_ELEMENTS]") ByteBuffer value) {
        StdVideoH265ScalingLists.nScalingList16x16(this.address(), value);
        return this;
    }

    public StdVideoH265ScalingLists ScalingList16x16(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoH265ScalingLists.nScalingList16x16(this.address(), index, value);
        return this;
    }

    public StdVideoH265ScalingLists ScalingList32x32(@NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_32X32_NUM_ELEMENTS]") ByteBuffer value) {
        StdVideoH265ScalingLists.nScalingList32x32(this.address(), value);
        return this;
    }

    public StdVideoH265ScalingLists ScalingList32x32(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoH265ScalingLists.nScalingList32x32(this.address(), index, value);
        return this;
    }

    public StdVideoH265ScalingLists ScalingListDCCoef16x16(@NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_16X16_NUM_LISTS]") ByteBuffer value) {
        StdVideoH265ScalingLists.nScalingListDCCoef16x16(this.address(), value);
        return this;
    }

    public StdVideoH265ScalingLists ScalingListDCCoef16x16(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoH265ScalingLists.nScalingListDCCoef16x16(this.address(), index, value);
        return this;
    }

    public StdVideoH265ScalingLists ScalingListDCCoef32x32(@NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_32X32_NUM_LISTS]") ByteBuffer value) {
        StdVideoH265ScalingLists.nScalingListDCCoef32x32(this.address(), value);
        return this;
    }

    public StdVideoH265ScalingLists ScalingListDCCoef32x32(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoH265ScalingLists.nScalingListDCCoef32x32(this.address(), index, value);
        return this;
    }

    public StdVideoH265ScalingLists set(ByteBuffer ScalingList4x4, ByteBuffer ScalingList8x8, ByteBuffer ScalingList16x16, ByteBuffer ScalingList32x32, ByteBuffer ScalingListDCCoef16x16, ByteBuffer ScalingListDCCoef32x32) {
        this.ScalingList4x4(ScalingList4x4);
        this.ScalingList8x8(ScalingList8x8);
        this.ScalingList16x16(ScalingList16x16);
        this.ScalingList32x32(ScalingList32x32);
        this.ScalingListDCCoef16x16(ScalingListDCCoef16x16);
        this.ScalingListDCCoef32x32(ScalingListDCCoef32x32);
        return this;
    }

    public StdVideoH265ScalingLists set(StdVideoH265ScalingLists src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoH265ScalingLists malloc() {
        return StdVideoH265ScalingLists.wrap(StdVideoH265ScalingLists.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static StdVideoH265ScalingLists calloc() {
        return StdVideoH265ScalingLists.wrap(StdVideoH265ScalingLists.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static StdVideoH265ScalingLists create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return StdVideoH265ScalingLists.wrap(StdVideoH265ScalingLists.class, MemoryUtil.memAddress(container), container);
    }

    public static StdVideoH265ScalingLists create(long address) {
        return StdVideoH265ScalingLists.wrap(StdVideoH265ScalingLists.class, address);
    }

    @Nullable
    public static StdVideoH265ScalingLists createSafe(long address) {
        return address == 0L ? null : StdVideoH265ScalingLists.wrap(StdVideoH265ScalingLists.class, address);
    }

    public static Buffer malloc(int capacity) {
        return StdVideoH265ScalingLists.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(StdVideoH265ScalingLists.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return StdVideoH265ScalingLists.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoH265ScalingLists.__create(capacity, SIZEOF);
        return StdVideoH265ScalingLists.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return StdVideoH265ScalingLists.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : StdVideoH265ScalingLists.wrap(Buffer.class, address, capacity);
    }

    public static StdVideoH265ScalingLists malloc(MemoryStack stack) {
        return StdVideoH265ScalingLists.wrap(StdVideoH265ScalingLists.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static StdVideoH265ScalingLists calloc(MemoryStack stack) {
        return StdVideoH265ScalingLists.wrap(StdVideoH265ScalingLists.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return StdVideoH265ScalingLists.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return StdVideoH265ScalingLists.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nScalingList4x4(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)SCALINGLIST4X4, 16);
    }

    public static byte nScalingList4x4(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)SCALINGLIST4X4 + Checks.check(index, 16) * 1L);
    }

    public static ByteBuffer nScalingList8x8(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)SCALINGLIST8X8, 64);
    }

    public static byte nScalingList8x8(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)SCALINGLIST8X8 + Checks.check(index, 64) * 1L);
    }

    public static ByteBuffer nScalingList16x16(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)SCALINGLIST16X16, 64);
    }

    public static byte nScalingList16x16(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)SCALINGLIST16X16 + Checks.check(index, 64) * 1L);
    }

    public static ByteBuffer nScalingList32x32(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)SCALINGLIST32X32, 64);
    }

    public static byte nScalingList32x32(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)SCALINGLIST32X32 + Checks.check(index, 64) * 1L);
    }

    public static ByteBuffer nScalingListDCCoef16x16(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)SCALINGLISTDCCOEF16X16, 6);
    }

    public static byte nScalingListDCCoef16x16(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)SCALINGLISTDCCOEF16X16 + Checks.check(index, 6) * 1L);
    }

    public static ByteBuffer nScalingListDCCoef32x32(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)SCALINGLISTDCCOEF32X32, 2);
    }

    public static byte nScalingListDCCoef32x32(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)SCALINGLISTDCCOEF32X32 + Checks.check(index, 2) * 1L);
    }

    public static void nScalingList4x4(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)SCALINGLIST4X4, value.remaining() * 1);
    }

    public static void nScalingList4x4(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)SCALINGLIST4X4 + Checks.check(index, 16) * 1L, value);
    }

    public static void nScalingList8x8(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)SCALINGLIST8X8, value.remaining() * 1);
    }

    public static void nScalingList8x8(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)SCALINGLIST8X8 + Checks.check(index, 64) * 1L, value);
    }

    public static void nScalingList16x16(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)SCALINGLIST16X16, value.remaining() * 1);
    }

    public static void nScalingList16x16(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)SCALINGLIST16X16 + Checks.check(index, 64) * 1L, value);
    }

    public static void nScalingList32x32(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)SCALINGLIST32X32, value.remaining() * 1);
    }

    public static void nScalingList32x32(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)SCALINGLIST32X32 + Checks.check(index, 64) * 1L, value);
    }

    public static void nScalingListDCCoef16x16(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 6);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)SCALINGLISTDCCOEF16X16, value.remaining() * 1);
    }

    public static void nScalingListDCCoef16x16(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)SCALINGLISTDCCOEF16X16 + Checks.check(index, 6) * 1L, value);
    }

    public static void nScalingListDCCoef32x32(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)SCALINGLISTDCCOEF32X32, value.remaining() * 1);
    }

    public static void nScalingListDCCoef32x32(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)SCALINGLISTDCCOEF32X32 + Checks.check(index, 2) * 1L, value);
    }

    static {
        Struct.Layout layout = StdVideoH265ScalingLists.__struct(StdVideoH265ScalingLists.__array(1, 16), StdVideoH265ScalingLists.__array(1, 64), StdVideoH265ScalingLists.__array(1, 64), StdVideoH265ScalingLists.__array(1, 64), StdVideoH265ScalingLists.__array(1, 6), StdVideoH265ScalingLists.__array(1, 2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SCALINGLIST4X4 = layout.offsetof(0);
        SCALINGLIST8X8 = layout.offsetof(1);
        SCALINGLIST16X16 = layout.offsetof(2);
        SCALINGLIST32X32 = layout.offsetof(3);
        SCALINGLISTDCCOEF16X16 = layout.offsetof(4);
        SCALINGLISTDCCOEF32X32 = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<StdVideoH265ScalingLists, Buffer>
    implements NativeResource {
        private static final StdVideoH265ScalingLists ELEMENT_FACTORY = StdVideoH265ScalingLists.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoH265ScalingLists getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_4X4_NUM_ELEMENTS]")
        public ByteBuffer ScalingList4x4() {
            return StdVideoH265ScalingLists.nScalingList4x4(this.address());
        }

        @NativeType(value="uint8_t")
        public byte ScalingList4x4(int index) {
            return StdVideoH265ScalingLists.nScalingList4x4(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_8X8_NUM_ELEMENTS]")
        public ByteBuffer ScalingList8x8() {
            return StdVideoH265ScalingLists.nScalingList8x8(this.address());
        }

        @NativeType(value="uint8_t")
        public byte ScalingList8x8(int index) {
            return StdVideoH265ScalingLists.nScalingList8x8(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_16X16_NUM_ELEMENTS]")
        public ByteBuffer ScalingList16x16() {
            return StdVideoH265ScalingLists.nScalingList16x16(this.address());
        }

        @NativeType(value="uint8_t")
        public byte ScalingList16x16(int index) {
            return StdVideoH265ScalingLists.nScalingList16x16(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_32X32_NUM_ELEMENTS]")
        public ByteBuffer ScalingList32x32() {
            return StdVideoH265ScalingLists.nScalingList32x32(this.address());
        }

        @NativeType(value="uint8_t")
        public byte ScalingList32x32(int index) {
            return StdVideoH265ScalingLists.nScalingList32x32(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_16X16_NUM_LISTS]")
        public ByteBuffer ScalingListDCCoef16x16() {
            return StdVideoH265ScalingLists.nScalingListDCCoef16x16(this.address());
        }

        @NativeType(value="uint8_t")
        public byte ScalingListDCCoef16x16(int index) {
            return StdVideoH265ScalingLists.nScalingListDCCoef16x16(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_32X32_NUM_LISTS]")
        public ByteBuffer ScalingListDCCoef32x32() {
            return StdVideoH265ScalingLists.nScalingListDCCoef32x32(this.address());
        }

        @NativeType(value="uint8_t")
        public byte ScalingListDCCoef32x32(int index) {
            return StdVideoH265ScalingLists.nScalingListDCCoef32x32(this.address(), index);
        }

        public Buffer ScalingList4x4(@NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_4X4_NUM_ELEMENTS]") ByteBuffer value) {
            StdVideoH265ScalingLists.nScalingList4x4(this.address(), value);
            return this;
        }

        public Buffer ScalingList4x4(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoH265ScalingLists.nScalingList4x4(this.address(), index, value);
            return this;
        }

        public Buffer ScalingList8x8(@NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_8X8_NUM_ELEMENTS]") ByteBuffer value) {
            StdVideoH265ScalingLists.nScalingList8x8(this.address(), value);
            return this;
        }

        public Buffer ScalingList8x8(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoH265ScalingLists.nScalingList8x8(this.address(), index, value);
            return this;
        }

        public Buffer ScalingList16x16(@NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_16X16_NUM_ELEMENTS]") ByteBuffer value) {
            StdVideoH265ScalingLists.nScalingList16x16(this.address(), value);
            return this;
        }

        public Buffer ScalingList16x16(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoH265ScalingLists.nScalingList16x16(this.address(), index, value);
            return this;
        }

        public Buffer ScalingList32x32(@NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_32X32_NUM_ELEMENTS]") ByteBuffer value) {
            StdVideoH265ScalingLists.nScalingList32x32(this.address(), value);
            return this;
        }

        public Buffer ScalingList32x32(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoH265ScalingLists.nScalingList32x32(this.address(), index, value);
            return this;
        }

        public Buffer ScalingListDCCoef16x16(@NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_16X16_NUM_LISTS]") ByteBuffer value) {
            StdVideoH265ScalingLists.nScalingListDCCoef16x16(this.address(), value);
            return this;
        }

        public Buffer ScalingListDCCoef16x16(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoH265ScalingLists.nScalingListDCCoef16x16(this.address(), index, value);
            return this;
        }

        public Buffer ScalingListDCCoef32x32(@NativeType(value="uint8_t[STD_VIDEO_H265_SCALING_LIST_32X32_NUM_LISTS]") ByteBuffer value) {
            StdVideoH265ScalingLists.nScalingListDCCoef32x32(this.address(), value);
            return this;
        }

        public Buffer ScalingListDCCoef32x32(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoH265ScalingLists.nScalingListDCCoef32x32(this.address(), index, value);
            return this;
        }
    }
}

