/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeH265ReferenceInfoFlags;

public class StdVideoEncodeH265ReferenceInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PICORDERCNTVAL;
    public static final int TEMPORALID;
    public static final int FLAGS;

    public StdVideoEncodeH265ReferenceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoEncodeH265ReferenceInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int PicOrderCntVal() {
        return StdVideoEncodeH265ReferenceInfo.nPicOrderCntVal(this.address());
    }

    @NativeType(value="uint8_t")
    public byte TemporalId() {
        return StdVideoEncodeH265ReferenceInfo.nTemporalId(this.address());
    }

    public StdVideoEncodeH265ReferenceInfoFlags flags() {
        return StdVideoEncodeH265ReferenceInfo.nflags(this.address());
    }

    public StdVideoEncodeH265ReferenceInfo PicOrderCntVal(@NativeType(value="int32_t") int value) {
        StdVideoEncodeH265ReferenceInfo.nPicOrderCntVal(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceInfo TemporalId(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265ReferenceInfo.nTemporalId(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceInfo flags(StdVideoEncodeH265ReferenceInfoFlags value) {
        StdVideoEncodeH265ReferenceInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceInfo flags(Consumer<StdVideoEncodeH265ReferenceInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeH265ReferenceInfo set(int PicOrderCntVal, byte TemporalId, StdVideoEncodeH265ReferenceInfoFlags flags) {
        this.PicOrderCntVal(PicOrderCntVal);
        this.TemporalId(TemporalId);
        this.flags(flags);
        return this;
    }

    public StdVideoEncodeH265ReferenceInfo set(StdVideoEncodeH265ReferenceInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoEncodeH265ReferenceInfo malloc() {
        return StdVideoEncodeH265ReferenceInfo.wrap(StdVideoEncodeH265ReferenceInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static StdVideoEncodeH265ReferenceInfo calloc() {
        return StdVideoEncodeH265ReferenceInfo.wrap(StdVideoEncodeH265ReferenceInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static StdVideoEncodeH265ReferenceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return StdVideoEncodeH265ReferenceInfo.wrap(StdVideoEncodeH265ReferenceInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static StdVideoEncodeH265ReferenceInfo create(long address) {
        return StdVideoEncodeH265ReferenceInfo.wrap(StdVideoEncodeH265ReferenceInfo.class, address);
    }

    @Nullable
    public static StdVideoEncodeH265ReferenceInfo createSafe(long address) {
        return address == 0L ? null : StdVideoEncodeH265ReferenceInfo.wrap(StdVideoEncodeH265ReferenceInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return StdVideoEncodeH265ReferenceInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(StdVideoEncodeH265ReferenceInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return StdVideoEncodeH265ReferenceInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH265ReferenceInfo.__create(capacity, SIZEOF);
        return StdVideoEncodeH265ReferenceInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return StdVideoEncodeH265ReferenceInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : StdVideoEncodeH265ReferenceInfo.wrap(Buffer.class, address, capacity);
    }

    public static StdVideoEncodeH265ReferenceInfo malloc(MemoryStack stack) {
        return StdVideoEncodeH265ReferenceInfo.wrap(StdVideoEncodeH265ReferenceInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static StdVideoEncodeH265ReferenceInfo calloc(MemoryStack stack) {
        return StdVideoEncodeH265ReferenceInfo.wrap(StdVideoEncodeH265ReferenceInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return StdVideoEncodeH265ReferenceInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return StdVideoEncodeH265ReferenceInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nPicOrderCntVal(long struct) {
        return UNSAFE.getInt(null, struct + (long)PICORDERCNTVAL);
    }

    public static byte nTemporalId(long struct) {
        return UNSAFE.getByte(null, struct + (long)TEMPORALID);
    }

    public static StdVideoEncodeH265ReferenceInfoFlags nflags(long struct) {
        return StdVideoEncodeH265ReferenceInfoFlags.create(struct + (long)FLAGS);
    }

    public static void nPicOrderCntVal(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PICORDERCNTVAL, value);
    }

    public static void nTemporalId(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)TEMPORALID, value);
    }

    public static void nflags(long struct, StdVideoEncodeH265ReferenceInfoFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoEncodeH265ReferenceInfoFlags.SIZEOF);
    }

    static {
        Struct.Layout layout = StdVideoEncodeH265ReferenceInfo.__struct(StdVideoEncodeH265ReferenceInfo.__member(4), StdVideoEncodeH265ReferenceInfo.__member(1), StdVideoEncodeH265ReferenceInfo.__member(StdVideoEncodeH265ReferenceInfoFlags.SIZEOF, StdVideoEncodeH265ReferenceInfoFlags.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PICORDERCNTVAL = layout.offsetof(0);
        TEMPORALID = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH265ReferenceInfo, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH265ReferenceInfo ELEMENT_FACTORY = StdVideoEncodeH265ReferenceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoEncodeH265ReferenceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int PicOrderCntVal() {
            return StdVideoEncodeH265ReferenceInfo.nPicOrderCntVal(this.address());
        }

        @NativeType(value="uint8_t")
        public byte TemporalId() {
            return StdVideoEncodeH265ReferenceInfo.nTemporalId(this.address());
        }

        public StdVideoEncodeH265ReferenceInfoFlags flags() {
            return StdVideoEncodeH265ReferenceInfo.nflags(this.address());
        }

        public Buffer PicOrderCntVal(@NativeType(value="int32_t") int value) {
            StdVideoEncodeH265ReferenceInfo.nPicOrderCntVal(this.address(), value);
            return this;
        }

        public Buffer TemporalId(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265ReferenceInfo.nTemporalId(this.address(), value);
            return this;
        }

        public Buffer flags(StdVideoEncodeH265ReferenceInfoFlags value) {
            StdVideoEncodeH265ReferenceInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeH265ReferenceInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }
    }
}

